package com.bailuntec.cost.api.dto;

import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 接收到的推送物流单
 */
@Data
public class LogisticsCostDto {
    private Integer logisticsSupplierId; // 一级物流供应商ID
    private Integer subLogisticsSupplierId; // 二级物流供应商ID
    private Integer userId; //用户ID
    private BigDecimal amount; // 费用单金额
    private String currency; // 币种
    private String costRemark; // 费用单备注
    private String costReason; // 付款理由
    private String typeNo; //费用类别编号
    private String project; //所属项目
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date projectDate; //所属账期

    //费用来源 1-默认 2-WMS 3-调拨系统
    private String sourceFrom;
}
