package com.blt.other.module.cost.service.impl;

import com.bailuntec.common.exception.BizException;
import com.bailuntec.cost.api.dto.*;
import com.bailuntec.cost.api.request.ManageCostListReq;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.common.config.property.ProjectConstant;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.common.util.PathUtil;
import com.blt.other.database.model.*;
import com.blt.other.module.auth.dao.UserDao;
import com.blt.other.module.cost.dao.*;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostApiService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.service.UserCostFinansysService;
import com.blt.other.module.cost.service.impl.costcheck.CostContext;
import com.blt.other.module.cost.service.impl.costcheck.FinancialCheckState;
import com.blt.other.module.cost.utils.CostFileUtil;
import com.blt.other.module.cost.utils.CostUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class CostApiServiceImpl implements CostApiService {
    private static Logger logger = LoggerFactory.getLogger(CostApiServiceImpl.class);

    @Resource
    private CostDao costDao;
    @Resource
    private UserDao userDao;
    @Resource
    private CostDetailDao costDetailDao;
    @Resource
    private UserCostFinansysService userCostFinansysService;
    @Resource
    CostLogDao costLogDao;
    @Resource
    CostCompanyDao costCompanyDao;
    @Resource
    CostService costService;

    @Override
    @Transactional
    public String generateLogisticsCost(int costForm, LogisticsCostDto logisticsCostDto) throws Exception {
        CostDomain costDomain = new CostDomain();
        String costNo = CostUtils.getIdNum();
        costDomain.setCostNo(costNo);
        // 付款费用单 1付款  2收款  3借支/借还
        costDomain.setCostForm(costForm);

        //  0 待提交 1待审核 2待出纳付款 3被驳回 4已支付 5已作废
        costDomain.setCostStatus(0);
        costDomain.setCostRemark(logisticsCostDto.getCostRemark() + "【WMS系统推送】");
        costDomain.setCostReason(logisticsCostDto.getCostReason());
        CostTypeDomain costTypeDomain = null;
        if(logisticsCostDto.getTypeNo() == null || logisticsCostDto.getTypeNo().isEmpty()) {
            costTypeDomain = costTypeDao.selectByNameAndType("物流费", CostTypeDomain.FEE_TYPE);
        }
        else
        {
            costTypeDomain = costTypeDao.selectByNo(logisticsCostDto.getTypeNo());
        }
        costDomain.setCostType(costTypeDomain);

        costDomain.setCompanyName("香港百伦科技有限公司");
        costDomain.setCompanyNo("COM1806191800013");
        costDomain.setAmount(logisticsCostDto.getAmount());
        costDomain.setDic(logisticsCostDto.getCurrency());
        costDomain.setSourceFrom(logisticsCostDto.getSourceFrom());
        BigDecimal toRmbRate;
        if ("CNY".equals(logisticsCostDto.getCurrency())) {
            toRmbRate = BigDecimal.ONE;
            costDomain.setAmountRmb(logisticsCostDto.getAmount());
        } else {
            toRmbRate = CurUtils.getCur(logisticsCostDto.getCurrency(), "CNY");
            costDomain.setAmountRmb(logisticsCostDto.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        costDomain.setToRmbRate(toRmbRate);

        List<LogisticsFinansysDto> logisticsList = userCostFinansysService.getAllLogisticsFinance(); // 一级物流供应商
        List<SubLogisticsFinansysDto> subLogisticsList = userCostFinansysService.getAllSubLogisticsFinance(); // 二级物流供应商
        if (logisticsList != null && subLogisticsList != null) {
            if (logisticsCostDto.getSubLogisticsSupplierId() == 0) {
                // 没有二级，只有一级
                for (LogisticsFinansysDto logistics : logisticsList) {
                    if (logistics.getId().intValue() == logisticsCostDto.getLogisticsSupplierId().intValue()) {
                        costDomain.setLogisticsSupplierId(logistics.getId());
                        costDomain.setBankCompany(logistics.getName());
                        costDomain.setBankCardUser(logistics.getBankuser());
                        costDomain.setBankCard(logistics.getBankcard());
                        costDomain.setBankName(logistics.getBankname());
                        break;
                    }
                }
            } else {
                // 根据二级找一级
                for (SubLogisticsFinansysDto subLogistics : subLogisticsList) {
                    if (subLogistics.getId().intValue() == logisticsCostDto.getSubLogisticsSupplierId().intValue()) {
                        costDomain.setSubLogisticsSupplierId(subLogistics.getId());
                        for (LogisticsFinansysDto logistics : logisticsList) {
                            if (logistics.getId().intValue() == subLogistics.getParentid().intValue()) {
                                costDomain.setLogisticsSupplierId(logistics.getId());
                                costDomain.setBankCompany(logistics.getName());
                                costDomain.setBankCardUser(logistics.getBankuser());
                                costDomain.setBankCard(logistics.getBankcard());
                                costDomain.setBankName(logistics.getBankname());
                                break;
                            }
                        }
                        break;
                    }
                }
            }
        } else {
            throw new Exception("获取一二级物流供应商信息失败！");
        }
        logisticsList.clear();
        subLogisticsList.clear();

        if (costDomain.getLogisticsSupplierId() == null) {
            throw new Exception("没有匹配到一级物流供应商信息！");
        }

        UserDomain user = userDao.selectByuserid(logisticsCostDto.getUserId());
        if (user == null) {
            throw new Exception("费用系统中没有该用户信息，请先登录一次费用系统再进行推送！");
        } else {
            costDomain.setCreateUserid(user.getUserid());
            costDomain.setCreateUsername(user.getUsername());
            costDomain.setCreateUsercode(user.getUsercode());
            costDomain.setCreateTime(new Date());
        }
        costDomain.setCostTemplateIdByFrom();
        if(costForm != 1){
            costDomain.setProject(logisticsCostDto.getProject());
            costDomain.setProjectDate(logisticsCostDto.getProjectDate());
        }
        costDao.insert(costDomain);
        if (costForm == 1) {
            CostDetailDomain costDetailDomain = new CostDetailDomain();
            BeanUtils.copyProperties(costDomain, costDetailDomain);
            costDetailDomain.setProject(logisticsCostDto.getProject());
            costDetailDomain.setProjectDate(logisticsCostDto.getProjectDate());
            costDetailDomain.setDetailNo(costNo + "-1");
            costDetailDao.insert(costDetailDomain);
        }
        if(costDomain.getBankCard() != null && !costDomain.getBankCard().isEmpty()) {
            UserCostFinansysDomain userCostFinansysDomain = userCostFinansysService.createFinanceRecordByCostDomain(costDomain);
            userCostFinansysService.saveFinancesRecord(userCostFinansysDomain);
        }
        return costNo;
    }

    @Override
    public String generateCost(CostInputDto input) throws Exception {
        CostDomain costDomain = new CostDomain();
        BeanUtils.copyProperties(input,costDomain);
        String costNo = CostUtils.getIdNum();
        costDomain.setCostNo(costNo);
        //  0 待提交 1待审核 2待出纳付款 3被驳回 4已支付 5已作废
        costDomain.setCostStatus(0);
        if(input.getCostForm().equals(1)){
            costDomain.setCostTemplateId(3);
        }
        if(input.getCostForm().equals(2)){
            costDomain.setCostTemplateId(5);
        }

        //company
        CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(input.getCompanyNo());
        if (costCompanyDomain == null) {
            throw new Exception("费用系统中没有该主体信息");
        }
        costDomain.setCompanyName(costCompanyDomain.getCompanyName());
        costDomain.setCompanyValue(costCompanyDomain.getValue());

        //user
        UserDomain userDomain = userDao.selectByuserid(input.getCreateUserid());
        if (userDomain == null) {
            throw new Exception("费用系统中没有该用户信息，请先登录一次费用系统再进行推送！");
        }
        costDomain.setCreateUsername(userDomain.getUsername());
        costDomain.setCreateUsercode(userDomain.getUsercode());

        //costType , not set AccountingSubjectName
        CostTypeDomain costTypeDomain = costTypeDao.selectById(input.getTypeId());
        if (costTypeDomain == null) {
            throw new Exception("费用系统中没有该费用类型");
        }
        costDomain.setTypeNo(costTypeDomain.getTypeNo());
        costDomain.setTypeName(costTypeDomain.getTypeName());
        costDomain.setAccountingSubjectId(costTypeDomain.getAccountingSubjectId());
        costDomain.setAccountingSubjectNo(costTypeDomain.getAccountingSubjectNo());
        costDomain.setNsAccountingSubjectId(costTypeDomain.getNsAccountingSubjectId());
        //costDomain.setAccountingSubjectName()

        //汇率
        BigDecimal toRmbRate;
        if ("CNY".equals(input.getDic())) {
            toRmbRate = BigDecimal.ONE;
            costDomain.setAmountRmb(input.getAmount());
        } else {
            toRmbRate = CurUtils.getCur(input.getDic(), "CNY");
            costDomain.setAmountRmb(input.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        costDomain.setToRmbRate(toRmbRate);
        costDao.insert(costDomain);
        if (input.getCostForm() == 1) {
            CostDetailDomain costDetailDomain = new CostDetailDomain();
            BeanUtils.copyProperties(costDomain, costDetailDomain);
            costDetailDomain.setDetailNo(costNo + "-1");
            costDetailDao.insert(costDetailDomain);
        }
        if(costDomain.getBankCard() != null && !costDomain.getBankCard().isEmpty()) {
            UserCostFinansysDomain userCostFinansysDomain = userCostFinansysService.createFinanceRecordByCostDomain(costDomain);
            userCostFinansysService.saveFinancesRecord(userCostFinansysDomain);
        }
        return costNo;
    }

    @Override
    public String updateCost(CostInputDto input, String costNo) throws Exception{
        CostDomain costDomain = costService.getCostByCostNo(costNo);
        if(costDomain == null){
            throw new Exception("不存在费用单"+costNo);
        }
        if(!costDomain.getCreateUserid().equals(input.getCreateUserid())){
            throw new Exception("无权更改该费用单，该费用单不是您所创建");
        }
        if(!input.getCostForm().equals(costDomain.getCostForm())){
            throw new Exception("不能更改费用单类型");
        }
        boolean sameTypeId = input.getTypeId().equals(costDomain.getTypeId());
        BeanUtils.copyProperties(input,costDomain);
        //costType , not set AccountingSubjectName
        if(!sameTypeId) {
            CostTypeDomain costTypeDomain = costTypeDao.selectById(input.getTypeId());
            if (costTypeDomain == null) {
                throw new Exception("费用系统中没有该费用类型");
            }
            costDomain.setTypeNo(costTypeDomain.getTypeNo());
            costDomain.setTypeName(costTypeDomain.getTypeName());
            costDomain.setAccountingSubjectId(costTypeDomain.getAccountingSubjectId());
            costDomain.setAccountingSubjectNo(costTypeDomain.getAccountingSubjectNo());
            costDomain.setNsAccountingSubjectId(costTypeDomain.getNsAccountingSubjectId());
            //costDomain.setAccountingSubjectName()
            if(costDomain.getCostForm() == 1) {
                List<CostDetailDomain> costDetailDomainList = costDetailDao.selectListByCostNo(costDomain.getCostNo());
                CostDetailDomain costDetailDomain = costDetailDomainList.get(0);
                BeanUtils.copyProperties(costDomain, costDetailDomain, "id", "detailNo", "costNo","createUserid","createUsername");
                costDetailDao.updateById(costDetailDomain);
            }
        }
        //汇率
        BigDecimal toRmbRate;
        if ("CNY".equals(input.getDic())) {
            toRmbRate = BigDecimal.ONE;
            costDomain.setAmountRmb(input.getAmount());
        } else {
            toRmbRate = CurUtils.getCur(input.getDic(), "CNY");
            costDomain.setAmountRmb(input.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        costDomain.setToRmbRate(toRmbRate);
        if(input.getInvalid() != null && input.getInvalid()){
            //作废
            if(costDomain.getCostStatus() == CostDomain.STATUS_UN_SUBMIT || costDomain.getCostStatus() == CostDomain.STATUS_REJECT){
                costDomain.setCostStatus(CostDomain.STATUS_DELETE);
            }else {
                throw new Exception("该状态下，无法作废费用单");
            }
        }
        costDao.update(costDomain, new LambdaQueryWrapper<CostDomain>()
                .eq(CostDomain::getCostNo, costDomain.getCostNo()));
        return "更新成功";
    }

    @Override
    public List<CostDomain> getNoPayCost(List<String> costNoList) {
        return costDao.selectList(new LambdaQueryWrapper<CostDomain>()
                .eq(CostDomain::getCostForm, CostDomain.COST_FROM_1)
                .eq(CostDomain::getCostStatus, CostDomain.STATUS_PAYED)
                .in(CostDomain::getCostNo, costNoList));
    }

    @Override
    public CostDomain getCostDetails(String costNo) {
        return costService.getCostByCostNo(costNo);
    }

    @Resource
    CostTypeDao costTypeDao;
    @Resource
    FinancialCheckState financialCheckState;

    @Override
    public String pushWageCost(WageCostDto wageCostDto) throws IOException {
        CostDomain costDomain = new CostDomain();
        String costNo = CostUtils.getIdNum();
        costDomain.setCostNo(costNo);
        // 付款费用单 1付款  2收款  3借支/借还
        costDomain.setCostForm(CostDomain.COST_FROM_1);
        // 0 待提交 1待审核 2待出纳付款 3被驳回 4已支付 5已作废
        costDomain.setCostStatus(CostDomain.STATUS_FINANCIAL_CHECK);

        //类型信息
        CostTypeDomain costTypeDomain = costTypeDao.selectByNameAndType("工资", CostTypeDomain.FEE_TYPE);
        costDomain.setCostType(costTypeDomain);


        //公司
        CostCompanyDomain costCompany = costCompanyDao.selectByName(wageCostDto.getCompanyName());
        costDomain.setCompanyNo(costCompany.getCompanyNo());

        //财务主体信息
        costDomain.setCompanyName(wageCostDto.getCompanyName());
        costDomain.setCompanyValue(wageCostDto.getCompanyValue());

        //银行卡四要素
        costDomain.setBankCard(wageCostDto.getBankCard());
        costDomain.setBankCardUser(wageCostDto.getBankCardUser());
        costDomain.setBankCompany(wageCostDto.getBankCompany());
        costDomain.setBankName(wageCostDto.getBankName());

        //金额信息
        costDomain.setAmount(wageCostDto.getAmount());
        costDomain.setDic(wageCostDto.getCurrency());

        //费用单来源
        costDomain.setSourceFrom(wageCostDto.getSourceFrom());

        costDomain.setCostRemark(wageCostDto.getCostRemark());
        costDomain.setCostReason(wageCostDto.getCostReason());

        BigDecimal toRmbRate;

        //todo simplify
        if (ProjectConstant.CNY.equals(wageCostDto.getCurrency())) {
            toRmbRate = BigDecimal.ONE;
            costDomain.setAmountRmb(wageCostDto.getAmount());
        } else {
            toRmbRate = CurUtils.getCur(wageCostDto.getCurrency(), ProjectConstant.CNY);
            costDomain.setAmountRmb(wageCostDto.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        costDomain.setToRmbRate(toRmbRate);

        UserDomain user = userDao.selectByuserid(wageCostDto.getUserId());
        if (user == null) {
            throw new BizRuntimeException("费用系统中没有该用户信息，请先登录一次费用系统再进行推送！");
        } else {
            costDomain.setCreateUserid(user.getUserid());
            costDomain.setCreateUsername(user.getUsername());
            costDomain.setCreateTime(new Date());
        }
        costDomain.setCostTemplateIdByFrom();
        //写入费用单
        costDao.insert(costDomain);

        //写入费用单详情
        CostDetailDomain costDetailDomain = new CostDetailDomain();

        // 文件上传的路径
        //String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + costDomain.getCostNo() + "/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.qiniuUpload(wageCostDto.getFileUrl());

        BeanUtils.copyProperties(costDomain, costDetailDomain);
        costDetailDomain.setDetailNo(costNo + "-1");
        costDetailDomain.setFilePath(path);
        costDetailDomain.setProject(wageCostDto.getProject());
        costDetailDao.insert(costDetailDomain);

        CostLogDomain costLogDomain = new CostLogDomain();
        costLogDomain.setCostNo(costNo);
        costLogDomain.setUpdateUserid(user.getUserid());
        costLogDomain.setUpdateUsername(user.getUsername());
        costLogDomain.setUpdateTime(new Date());
        costLogDomain.setUpdateNote("老板已经审批通过了");
        costLogDomain.setUpdateUsercode(user.getUsercode());
        costLogDao.insert(costLogDomain);


        CostContext costContext = new CostContext(costNo, costDomain.getCreateUserid());
        costContext.setCostState(financialCheckState);
        financialCheckState.updateCurrentReviewer();

        return costNo;
    }

    @Override
    public List<CostDto> getCostList(String startDate, String endDate, Integer pageNum, Integer pageSize) {
        IPage<CostDomain> page = new Page<>(pageNum, pageSize);

        return this.costDao.getCostList(page, startDate, endDate)
                .stream()
                .map(CostDomain::castToDto)
                .collect(Collectors.toList());
    }

    @Override
    public List<ManageCostDto> manageCostList(ManageCostListReq req) {
        List<CostDomain> manageCostList = costDao.manageCostList(req);
        costService.setPrimaryDepartment(manageCostList);

        return manageCostList.stream()
                .map(costDomain -> {
                    ManageCostDto manageCostDto = new ManageCostDto();
                    manageCostDto.setAmount(costDomain.getAmount());
                    manageCostDto.setAmountRmb(costDomain.getAmountRmb());
                    manageCostDto.setCompanyName(costDomain.getCompanyName());
                    manageCostDto.setCompanyValue(costDomain.getCompanyValue());
                    manageCostDto.setCostId(costDomain.getId());
                    manageCostDto.setCurrency(costDomain.getDic());
                    manageCostDto.setManageCostType(costDomain.getCostForm());
                    manageCostDto.setNo(costDomain.getCostNo());

                    manageCostDto.setReason(costDomain.getCostReason());
                    //银行卡四要素
                    manageCostDto.setReceiveBank(costDomain.getBankName());
                    manageCostDto.setReceiveCard(costDomain.getBankCard());
                    manageCostDto.setReceiveCardUser(costDomain.getBankCardUser());
                    manageCostDto.setReceiveUnit(costDomain.getBankCompany());

                    manageCostDto.setPayTime(costDomain.getActualTime());
                    manageCostDto.setFeeSuperType(costDomain.getTypeName());

                    manageCostDto.setDepartmentName(costDomain.getPrimaryDepartmentName());
                    manageCostDto.setAccountingSubjectName(costDomain.getAccountingSubjectName());
                    manageCostDto.setRemark(costDomain.getCostRemark());
                    return manageCostDto;
                })
                .collect(Collectors.toList());
    }
}
