package com.blt.other.module.cost.service.impl;

import com.bailuntec.common.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.AccountingSubjectMapper;
import com.blt.other.module.cost.dto.request.AccountingSubjectAddReq;
import com.blt.other.module.cost.dto.request.AccountingSubjectModifyReq;
import com.blt.other.module.cost.model.AccountingSubject;
import com.blt.other.module.cost.service.IAccountingSubjectService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-12-17
 */
@Service
@Slf4j
public class AccountingSubjectServiceImpl extends ServiceImpl<AccountingSubjectMapper, AccountingSubject> implements IAccountingSubjectService {

    @Resource
    OaUserMapper oaUserMapper;

    @Override
    public void add(AccountingSubjectAddReq req) {


        AccountingSubject accountingSubject = new AccountingSubject();
        accountingSubject.setSubjectNo(req.getSubjectNo());
        accountingSubject.setName(req.getName());
        accountingSubject.setUpdateUserId(req.getUpdateUserId());

        OaUser oaUser = oaUserMapper.selectByOaUserId(req.getUpdateUserId());
        accountingSubject.setUpdateUser(oaUser.getUserName());
        accountingSubject.setUpdateUserId(req.getUpdateUserId());
        accountingSubject.setCreateTime(LocalDateTime.now());
        accountingSubject.setLastUpdateTime(LocalDateTime.now());
        this.save(accountingSubject);
    }


    @Override
    public void modify(AccountingSubjectModifyReq req) {

        AccountingSubject accountingSubject = baseMapper.selectById(req.getId());

        accountingSubject.setSubjectNo(req.getSubjectNo());
        accountingSubject.setUpdateUserId(req.getUpdateUserId());

        OaUser oaUser = oaUserMapper.selectByOaUserId(req.getUpdateUserId());
        accountingSubject.setUpdateUser(oaUser.getUserName());
        accountingSubject.setLastUpdateTime(LocalDateTime.now());

        if (StringUtils.isNotEmpty(req.getName())) {
            accountingSubject.setName(req.getName());
        }
        baseMapper.updateById(accountingSubject);
    }
}
