package com.blt.other.cost.service.impl.costplan;

import com.bailuntec.common.SpringContextUtil;
import com.blt.other.cost.dao.CostPlanDao;
import com.blt.other.cost.service.CostPlanService;
import com.blt.other.database.model.CostPlanDomain;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/17 10:13 上午
 */
public class CostPlanServiceFactory {

    public static CostPlanService getCostPlanService() {
        return SpringContextUtil.getBean(DefaultCostPlanServiceImpl.class);
    }


    public static CostPlanService getCostPlanService(String costPlanNo) {
        CostPlanDao costPlanDao = SpringContextUtil.getBean(CostPlanDao.class);
        return getCostPlanService(costPlanDao.selectByNo(costPlanNo));
    }

    public static CostPlanService getCostPlanService(CostPlanDomain costPlanDomain) {

        if (costPlanDomain.getCostForm().equals(1)) {
            return SpringContextUtil.getBean(CostPlanNewPayServiceImpl.class);
        }
        if (costPlanDomain.getCostForm().equals(2)) {
            return SpringContextUtil.getBean(CostPlanNewReceiptServiceImpl.class);
        }
        if (costPlanDomain.getCostForm().equals(3) && costPlanDomain.getIsLend().equals(1)) {
            return SpringContextUtil.getBean(CostPlanNewLend1ServiceImpl.class);
        }
        if (costPlanDomain.getCostForm().equals(3) && costPlanDomain.getIsLend().equals(2)) {
            return SpringContextUtil.getBean(CostPlanNewLend2ServiceImpl.class);
        }
        return SpringContextUtil.getBean(DefaultCostPlanServiceImpl.class);
    }


}


