package com.blt.other.cost.service.impl.costplan;

import com.blt.other.commons.utils.CurUtils;
import com.blt.other.cost.service.CostPlanService;
import com.blt.other.database.model.CostDomain;
import com.blt.other.database.model.CostPlanDomain;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

/**
 * <p>
 * 收款单类型
 * </p>
 *
 * @author robbendev
 * @since 2020/10/16 1:25 下午
 */
@Transactional(rollbackFor = Exception.class)
@Service
public class CostPlanNewReceiptServiceImpl extends AbstractCostPlanService implements CostPlanService {

    @Override
    public void save(CostPlanDomain planDomain) {
        this.doSaveFinansyRecord(planDomain);
        this.completedCostPlan(planDomain);
        costPlanDao.insert(planDomain);
    }

    @Override
    public void update(CostPlanDomain planDomain) {
        this.doSaveFinansyRecord(planDomain);
        this.completedCostPlan(planDomain);
        costPlanDao.update(planDomain);
    }

    @Override
    public Integer affirm(String costPlanNo) {
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);

        CostDomain costDomain = planToCost(costPlanNo);
        String costNo = getCostNo();
        costDomain.setCostNo(costNo);
        costDomain.setCostStatus(0);
        costDomain.setAmount(costPlanDomain.getPlanAmount());
        BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY", getExchangeRateApi);
        costDomain.setToRmbRate(toRmbRate);
        costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        Integer insert = costDao.insert(costDomain);

        // 记录日志
        costLogService.save(costDomain.getCostNo(), costDomain.getCreateUserid(), "由费用计划：" + costDomain.getCostPlanNo() + " 生成收款单");
        return insert;
    }
}
