package com.blt.other.cost.dao;

import com.blt.other.database.model.CostPlanDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface CostPlanDao {

    CostPlanDomain selectByNo(String costPlanNo);

    Integer insert(CostPlanDomain plan);

    /**
     * <p>
     * 根据计划单号更新计划单
     * </p>
     *
     * @param costPlanDomain 计划单
     * @return res
     */
    Integer update(CostPlanDomain costPlanDomain);

    Integer deleted(String costPlanNo);

    List<CostPlanDomain> selectAll(@Param("userId") Integer userId);
}
