package com.blt.other.cost.controller;

import com.blt.other.commons.utils.AxiosUtil;
import com.bailuntec.cost.api.dto.CostCompanyFinansysDto;
import com.blt.other.cost.service.CostCompanyFinansysService;
import com.blt.other.cost.service.CostCompanyService;
import com.blt.other.cost.vo.CostCompanyVo;
import com.blt.other.database.model.CostCompanyDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("cost/list/add")
public class CostListAddReceiptController {

    @Autowired
    private CostCompanyService costCompanyService;

    @Autowired
    private CostCompanyFinansysService costCompanyFinansysService;

    @PostMapping("/getCompanyFinansysByNo")
    public Map<String,Object> getCompanyFinansysByNo(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String companyNo = request.getParameter("companyNo");

        CostCompanyDomain companyByCompanyNo = costCompanyService.getCompanyByCompanyNo(companyNo);

        CostCompanyVo costCompanyVo = costCompanyFinansysService.getCostCompanyVo(companyByCompanyNo.getValue());
        List<CostCompanyFinansysDto> costCompanyFinansysDto = null;
        if (null != costCompanyVo){
            costCompanyFinansysDto = costCompanyFinansysService.getCostCompanyFinansysDto(costCompanyVo);
        }

        Map<String,Object> result = new HashMap<>();
        result.put("finansysList",costCompanyFinansysDto);
        result.put("success",true);
        return result;
    }

    @PostMapping("/getMainFinansys")
    public Map<String,Object> getMainFinansys(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String mValue = request.getParameter("mValue");
        String[] split = mValue.split("~");
        CostCompanyVo costCompanyVo = costCompanyFinansysService.getCostCompanyVo(Integer.parseInt(split[0]));
        List<CostCompanyFinansysDto> costCompanyFinansysDto = costCompanyFinansysService.getCostCompanyFinansysDto(costCompanyVo);

        if (null != costCompanyFinansysDto && costCompanyFinansysDto.size() >= 1){
            for (CostCompanyFinansysDto costCompanyFinansys : costCompanyFinansysDto){
                if (costCompanyFinansys.getId() == Integer.parseInt(split[1])){
                    result.put("success",true);
                    result.put("msg","");
                    result.put("finansys",costCompanyFinansys);
                    return result;
                }
            }
        }
        return null;
    }
}
