package com.blt.other.cost.config;
import com.blt.other.cost.job.UserCostFinansysSyncJob;
import org.quartz.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 费用系统财务信息同步定时器配置
 */
@Configuration
public class UserCostFinansysSyncJobConfiguration {


    // 扫描主体列表时间间隔：（秒）
    private static final int TIME = 86400;

    // JobDetail 定义要执行的 job
    @Bean
    public JobDetail userCostFinansysSyncJobDetail(){
        return JobBuilder.newJob(UserCostFinansysSyncJob.class)
                .withIdentity("userCostFinansysSyncJob")
                .storeDurably().build();
    }

    // 触发 Bean 的 Trigger
    @Bean
    public Trigger userCostFinansysSyncJobTrigger(){
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule()
                .withIntervalInSeconds(TIME).repeatForever();
        return TriggerBuilder.newTrigger().forJob(userCostFinansysSyncJobDetail())
                .withIdentity("userCostFinansysSyncTrigger")
                .withSchedule(simpleScheduleBuilder).build();
    }
}
