package com.blt.other.commons.controller;

import com.blt.other.commons.service.IndexService;
import com.blt.other.commons.utils.AxiosUtil;
import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostPlanDto;
import com.blt.other.purchasing.dto.BuyPlanDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/index")
public class IndexController {

    @Autowired
    private IndexService indexService;

    @GetMapping("/getBuyPlanList")
    public Map<String,Object> getBuyPlanList(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String userid = request.getParameter("userid");
        List<BuyPlanDto> buyPlanList = indexService.getBuyPlanList(Integer.parseInt(userid));
        Map<String,Object> result = new HashMap<>();
        result.put("buyPlanList",buyPlanList);
        result.put("success",true);
        return result;
    }

    @GetMapping("/getCostPlanList")
    public Map<String,Object> getCostPlanList(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String userid = request.getParameter("userid");
        List<CostPlanDto> costPlanDtos = indexService.getCostPlanList(Integer.parseInt(userid));
        Map<String,Object> result = new HashMap<>();
        result.put("costPlanList",costPlanDtos);
        result.put("success",true);
        return result;
    }

    @GetMapping("/getCostList")
    public Map<String,Object> getCostList(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String userid = request.getParameter("userid");
        List<CostDto> costDtos = indexService.getCostList(Integer.parseInt(userid));
        Map<String,Object> result = new HashMap<>();
        result.put("costList",costDtos);
        result.put("success",true);
        return result;
    }
}
