package com.blt.other.auth.service.impl;

import com.bailuntec.common.ListUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.auth.dao.CostReviewerMapper;
import com.blt.other.auth.dao.OaCompanyMapper;
import com.blt.other.auth.dao.OaUserMapper;
import com.blt.other.auth.dto.request.CompanyReviewerListReq;
import com.blt.other.auth.model.CostReviewer;
import com.blt.other.auth.model.OaCompany;
import com.blt.other.auth.model.OaUser;
import com.blt.other.auth.service.IOaCompanyService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
@Service
public class OaCompanyServiceImpl extends ServiceImpl<OaCompanyMapper, OaCompany> implements IOaCompanyService {

    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    OaUserMapper oaUserMapper;

    @Override
    public List<OaCompany> oaCompanyList() {
        return this.list();
    }

    @Override
    public IPage<OaCompany> reviewerList(CompanyReviewerListReq req) {

        IPage<OaCompany> page = new Page<>(req.getPageNum(), req.getPageSize());

        page = baseMapper.reviewerList(page, req);

        if (ListUtil.isNotEmpty(page.getRecords())) {
            List<Integer> oaCompanyIds = page.getRecords().stream().map(OaCompany::getOaCompanyId).collect(Collectors.toList());

            //最终审核人
            List<CostReviewer> finalCostReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .in(CostReviewer::getReferId, oaCompanyIds)
                    .eq(CostReviewer::getType, CostReviewer.finalReviewer));

            Map<Integer, CostReviewer> finalReviewerMap = finalCostReviewerList.stream().collect(Collectors.toMap(CostReviewer::getReferId, costReviewer -> costReviewer));
            page.getRecords().forEach(record -> record.setFinalReviewer(finalReviewerMap.get(record.getOaCompanyId())));

            //财务审核人
            List<CostReviewer> financialCostReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .in(CostReviewer::getReferId, oaCompanyIds)
                    .eq(CostReviewer::getType, CostReviewer.financialReviewer));

            Map<Integer, CostReviewer> financialReviewerMap = financialCostReviewerList.stream().collect(Collectors.toMap(CostReviewer::getReferId, costReviewer -> costReviewer));
            page.getRecords().forEach(record -> {
                record.setFinalReviewer(financialReviewerMap.get(record.getOaCompanyId()));
            });
        }

        return page;
    }

    @Override
    public void modifyFinalReviewer(Integer userId, Integer oaCompanyId, Integer finalReviewerUserId) {


        OaUser currentOaUser = oaUserMapper.selectByOaUserId(userId);
        OaCompany oaCompany = baseMapper.selectByCompanyId(oaCompanyId);

        //记录更新时间
        oaCompany.setLastUpdateTime(LocalDateTime.now());
        oaCompany.setUpdateUserId(userId);
        oaCompany.setUpdateUserName(currentOaUser.getUserName());
        baseMapper.updateById(oaCompany);


        //删除旧审核人
        costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                .eq(CostReviewer::getType, CostReviewer.finalReviewer)
                .eq(CostReviewer::getReferId, oaCompanyId));


        //新增审核人
        OaUser oaUser = oaUserMapper.selectByOaUserId(finalReviewerUserId);
        CostReviewer costReviewer = CostReviewer.builder()
                .reviewerUserId(finalReviewerUserId)
                .reviewerUserName(oaUser.getUserName())
                .referId(oaCompanyId)
                .type(CostReviewer.finalReviewer)
                .build();

        costReviewerMapper.insert(costReviewer);
    }

    @Override
    public void modifyFinancialReviewer(Integer userId, Integer oaCompanyId, List<Integer> financialReviewerUserIds) {


        OaUser currentOaUser = oaUserMapper.selectByOaUserId(userId);
        OaCompany oaCompany = baseMapper.selectByCompanyId(oaCompanyId);

        //记录更新时间
        oaCompany.setLastUpdateTime(LocalDateTime.now());
        oaCompany.setUpdateUserId(userId);
        oaCompany.setUpdateUserName(currentOaUser.getUserName());
        baseMapper.updateById(oaCompany);

        //删除旧审核人
        costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                .eq(CostReviewer::getType, CostReviewer.financialReviewer)
                .eq(CostReviewer::getReferId, oaCompanyId));

        financialReviewerUserIds.forEach(financialReviewerUserId -> {
            //新增审核人
            OaUser financialReviewerOaUser = oaUserMapper.selectByOaUserId(financialReviewerUserId);
            CostReviewer costReviewer = CostReviewer.builder()
                    .reviewerUserId(financialReviewerUserId)
                    .reviewerUserName(financialReviewerOaUser.getUserName())
                    .referId(oaCompanyId)
                    .type(CostReviewer.finalReviewer)
                    .build();

            costReviewerMapper.insert(costReviewer);
        });
    }
}
