package com.blt.other.module.cost.dto.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Data
@ApiModel("审批请求Model")
public class ApprovalHistoryReq {

    @ApiModelProperty(value = "审批时间-起始时间", required = true, example = "2021-08-25 00:00:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "审批时间-结束时间", required = true, example = "2021-08-26 00:00:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endTime;

    @ApiModelProperty("审批前费用单状态")
    private Integer costStatus;

    @ApiModelProperty("费用类型")
    private String typeNo;

    @ApiModelProperty("费用单号，支持模糊搜索")
    private String costNo;
}
