package com.blt.other.other_cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.blt.other.other_auth.dao.UserDao;
import com.blt.other.other_commons.utils.CurUtils;
import com.blt.other.other_commons.utils.DateTimeUtil;
import com.blt.other.other_commons.utils.HttpUtil;
import com.blt.other.other_commons.utils.PathUtil;
import com.blt.other.other_cost.dao.*;
import com.blt.other.other_cost.dto.*;
import com.blt.other.other_cost.service.CostApiService;
import com.blt.other.other_cost.service.CostService;
import com.blt.other.other_cost.service.UserCostFinansysService;
import com.blt.other.other_cost.utils.CostFileUtil;
import com.blt.other.other_cost.utils.CostUtils;
import com.blt.other.other_database.model.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class CostApiServiceImpl implements CostApiService {
    private static Logger logger = LoggerFactory.getLogger(CostApiServiceImpl.class);

    @Autowired
    private CostDao costDao;

    @Autowired
    private CostService costService;

    @Autowired
    private CostTypeKindDao costTypeKindDao;
    @Autowired
    private CostTypeDao costTypeDao;

    @Autowired
    private UserDao userDao;

    @Autowired
    private CostDetailDao costDetailDao;

    @Autowired
    private UserCostFinansysService userCostFinansysService;

    @Value("${url.api.getConsumablesApi}")
    private String getConsumablesApiUrl;

    @Value("${url.api.getExchangeRateApi}")
    private String getExchangeRateApi;

    @Autowired
    CostLogDao costLogDao;

    @Override
    @Transactional
    public String generateLogisticsCost(int costForm, LogisticsCostDto logisticsCostDto) throws Exception {
        CostDomain costDomain = new CostDomain();
        String costNo = CostUtils.getIdNum(costService);
        costDomain.setCostNo(costNo);
        costDomain.setCostForm(costForm); // 付款费用单 1付款  2收款  3借支/借还
        costDomain.setCostStatus(0); //  0 待提交 1待审核 2待出纳付款 3被驳回 4已支付 5已作废
        costDomain.setCostRemark(logisticsCostDto.getCostRemark() + "【WMS系统推送】");
        costDomain.setCostReason(logisticsCostDto.getCostReason());
        costDomain.setTypeNo("CTN1809180519188");
        costDomain.setTypeName("销售费用/物流费");
        costDomain.setKindNo("CTK1809181719182");
        costDomain.setKindName("物流费");
        costDomain.setSubjectCode("660104");
        costDomain.setCompanyNo("COM1806191800013");
        costDomain.setCompanyValue(2); //dy
        costDomain.setCompanyName("香港百伦科技有限公司"); //dy
        costDomain.setAmount(logisticsCostDto.getAmount());
        costDomain.setDic(logisticsCostDto.getCurrency());
        costDomain.setSourceFrom(logisticsCostDto.getSourceFrom());
        BigDecimal toRmbRate = null;
        if ("CNY".equals(logisticsCostDto.getCurrency())) {
            toRmbRate = BigDecimal.ONE;
            costDomain.setAmountRmb(logisticsCostDto.getAmount());
        } else {
            toRmbRate = CurUtils.getCur(logisticsCostDto.getCurrency(), "CNY", getExchangeRateApi);
            costDomain.setAmountRmb(logisticsCostDto.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        costDomain.setToRmbRate(toRmbRate);

        List<LogisticsFinansysDto> logisticsList = userCostFinansysService.getAllLogisticsFinansys(); // 一级物流供应商
        List<SubLogisticsFinansysDto> subLogisticsList = userCostFinansysService.getAllSubLogisticsFinansys(); // 二级物流供应商
        if (logisticsList != null && subLogisticsList != null) {
            if (logisticsCostDto.getSubLogisticsSupplierId().intValue() == 0) {
                // 没有二级，只有一级
                for (LogisticsFinansysDto logistics : logisticsList) {
                    if (logistics.getId().intValue() == logisticsCostDto.getLogisticsSupplierId().intValue()) {
                        costDomain.setLogisticsSupplierId(logistics.getId());
                        costDomain.setBankCompany(logistics.getName());
                        costDomain.setBankCardUser(logistics.getBankuser());
                        costDomain.setBankCard(logistics.getBankcard());
                        costDomain.setBankName(logistics.getBankname());
                        break;
                    }
                }
            } else {
                // 根据二级找一级
                for (SubLogisticsFinansysDto subLogistics : subLogisticsList) {
                    if (subLogistics.getId().intValue() == logisticsCostDto.getSubLogisticsSupplierId().intValue()) {
                        costDomain.setSubLogisticsSupplierId(subLogistics.getId());
                        for (LogisticsFinansysDto logistics : logisticsList) {
                            if (logistics.getId().intValue() == subLogistics.getParentid().intValue()) {
                                costDomain.setLogisticsSupplierId(logistics.getId());
                                costDomain.setBankCompany(logistics.getName());
                                costDomain.setBankCardUser(logistics.getBankuser());
                                costDomain.setBankCard(logistics.getBankcard());
                                costDomain.setBankName(logistics.getBankname());
                                break;
                            }
                        }
                        break;
                    }
                }
            }
        } else {
            throw new Exception("获取一二级物流供应商信息失败！");
        }
        logisticsList.clear();
        subLogisticsList.clear();

        if (costDomain.getLogisticsSupplierId() == null) {
            throw new Exception("没有匹配到一级物流供应商信息！");
        }

        UserDomain user = userDao.selectByuserid(logisticsCostDto.getUserId());
        if (user == null) {
            throw new Exception("费用系统中没有该用户信息，请先登录一次费用系统再进行推送！");
        } else {
            costDomain.setCreateUserid(user.getUserid());
            costDomain.setCreateUsercode(user.getUsercode());
            costDomain.setCreateUsername(user.getUsername());
            costDomain.setCreateTime(new Date());
        }
        costDao.insert(costDomain);
        if (costForm == 1) {
            CostDetailDomain costDetailDomain = new CostDetailDomain();
            BeanUtils.copyProperties(costDomain, costDetailDomain);
            costDetailDomain.setDetailNo(costNo + "-1");
            costDetailDao.insert(costDetailDomain);
        }
        return costNo;
    }

    @Override
    public List<ManageCostDto> getMangeCostList(String startDateStr, String endDateStr, String feeSuperType, String feeSubType, Integer companyValue, String companyName, String departmentName, Integer createUserId, Integer payUserId) throws Exception {
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isEmpty(startDateStr)) {
            startDate = DateTimeUtil.stringToDate(startDateStr, DateTimeUtil.DATE_FORMAT);
        }
        if (!StringUtils.isEmpty(endDateStr)) {
            endDate = DateTimeUtil.stringToDate(endDateStr, DateTimeUtil.DATE_FORMAT);
        }
        ArrayList<Integer> companyValueList = new ArrayList<>(6);
        if (companyValue != null) {
            companyValueList.add(companyValue);
            if (companyValue.equals(53)) {
                companyValueList.add(50);
                companyValueList.add(59);
                companyValueList.add(60);
                companyValueList.add(61);
                companyValueList.add(66);
            }
        }


        List<ManageCostDto> manageCostDtoList = costDao.selectManageCost(startDate, DateTimeUtil.addDays(endDate, 1), feeSuperType, feeSubType, companyValueList, companyName, departmentName, createUserId, payUserId);
        if (manageCostDtoList != null && !manageCostDtoList.isEmpty()) {
            for (ManageCostDto manageCostDto : manageCostDtoList) {
                if (!manageCostDto.getCurrency().equals("CNY")) {
                    BigDecimal exhcnageRate = CurUtils.getCur(manageCostDto.getCurrency(), "CNY", getExchangeRateApi);
                    manageCostDto.setAmountRmb(manageCostDto.getAmount().multiply(exhcnageRate).setScale(4, RoundingMode.HALF_EVEN));
                }
            }
        }
        if ((companyValue == null || companyValue == 2) && ((feeSuperType == null && departmentName == null) ||
                (("耗材".equals(feeSuperType) || "耗材".equals(feeSubType)) && "采购部".equals(departmentName)) ||
                (("耗材".equals(feeSuperType) || "耗材".equals(feeSubType)) && departmentName == null))) {
            try {
                String param = "?companymainvalue_from=40&isquestion=-1&orderType=-1&cashier_type=1&sourcecode=buy&order=asc&offset=0&limit=1000" +
                        "&cashier_time_start=" + startDateStr + "&cashier_time_end=" + endDateStr;
                ConsumablesResultDto consumablesResultDto = JSONObject.parseObject(HttpUtil.httpGet(getConsumablesApiUrl + param), ConsumablesResultDto.class);
                if (consumablesResultDto.getTotal() > 0 && consumablesResultDto.getRows().size() > 0) {
                    for (ManageCostDto manageCostDto : consumablesResultDto.getRows()) {
                        manageCostDto.setReceiveUnit("余江县酷乐电子用品店");
                        manageCostDto.setReason("耗材");
                        manageCostDto.setManageCostType(-1);
                        manageCostDto.setDepartmentName("采购部");
                        manageCostDto.setCompanyValue(2);
                        manageCostDto.setCompanyName("香港百伦科技有限公司");
                        manageCostDto.setFeeSuperType("耗材");
                        manageCostDto.setFeeSubType("耗材");
                        if (!manageCostDto.getCurrency().equals("CNY")) {
                            BigDecimal exhcnageRate = CurUtils.getCur(manageCostDto.getCurrency(), "CNY", getExchangeRateApi);
                            manageCostDto.setAmountRmb(manageCostDto.getAmount().multiply(exhcnageRate).setScale(4, RoundingMode.HALF_EVEN));
                        }
                        manageCostDtoList.add(manageCostDto);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
                logger.error(">>>>>获取耗材信息失败");
            }
        }
        return manageCostDtoList;
    }

    @Override
    public List<ManageCostDto> getLogisticsCostList(String startDateStr, String endDateStr, String feeSuperType, String feeSubType, Integer companyValue, String companyName, String departmentName, Integer createUserId, Integer payUserId) throws Exception {
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isEmpty(startDateStr)) {
            startDate = DateTimeUtil.stringToDate(startDateStr, DateTimeUtil.DATE_FORMAT);
        }
        if (!StringUtils.isEmpty(endDateStr)) {
            endDate = DateTimeUtil.stringToDate(endDateStr, DateTimeUtil.DATE_FORMAT);
        }
        ArrayList<Integer> companyValueList = new ArrayList<>(6);
        if (companyValue != null) {
            companyValueList.add(companyValue);
            if (companyValue.equals(53)) {
                companyValueList.add(50);
                companyValueList.add(59);
                companyValueList.add(60);
                companyValueList.add(61);
                companyValueList.add(66);
            }
        }
        List<ManageCostDto> manageCostDtoList = costDao.getLogisticsCostList(startDate, DateTimeUtil.addDays(endDate, 1), feeSuperType, feeSubType, companyValueList, companyName, departmentName, createUserId, payUserId);

        return manageCostDtoList;
    }

    @Override
    public List<CostDomain> getBalanceSheetCost(Date startDate, Date endDate) {
        return costDao.selectBalanceSheetCost(startDate, endDate);
    }

    @Override
    public List<CostDomain> getNoPayCost(List<String> costNoList) {
        return costDao.selectNoPayCost(costNoList);
    }

    @Override
    public CostDomain getCostDetails(String costNo) {
        return costDao.selectByCostNo(costNo);
    }

    @Override
    public String pushWageCost(WageCostDto wageCostDto) throws IOException {
        CostDomain costDomain = new CostDomain();
        String costNo = CostUtils.getIdNum(costService);
        costDomain.setCostNo(costNo);
        // 付款费用单 1付款  2收款  3借支/借还
        costDomain.setCostForm(1);
        // 0 待提交 1待审核 2待出纳付款 3被驳回 4已支付 5已作废
        costDomain.setCostStatus(1);
        costDomain.setCostRemark(wageCostDto.getCostRemark());
        costDomain.setCostReason(wageCostDto.getCostReason());

//        CostTypeDomain costTypeDomain = costTypeDao.selectByCompanyNameAndTypeName(wageCostDto.getCompanyName(), "人工支出");

        CostTypeKindDomain sqlParam = new CostTypeKindDomain();
//        sqlParam.setTypeNo(costTypeDomain.getTypeNo());
        sqlParam.setKindName("工资");
        sqlParam.setCompanyName(wageCostDto.getCompanyName());

        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNameAndCompanyName("工资",wageCostDto.getCompanyName());

        costDomain.setTypeNo(costTypeKindDomain.getTypeNo());
        costDomain.setTypeName(costTypeKindDomain.getTypeName());
        costDomain.setSubjectCode(costTypeKindDomain.getSubjectCode());
        costDomain.setCompanyNo(costTypeKindDomain.getCompanyNo());
        costDomain.setCompanyName(wageCostDto.getCompanyName()); //dy
        costDomain.setCompanyValue(wageCostDto.getCompanyValue());

        costDomain.setBankCard(wageCostDto.getBankCard());
        costDomain.setBankCardUser(wageCostDto.getBankCardUser());
        costDomain.setBankCompany(wageCostDto.getBankCompany());
        costDomain.setBankName(wageCostDto.getBankName());


        costDomain.setKindNo(costTypeKindDomain.getKindNo());
        costDomain.setKindName(costTypeKindDomain.getKindName());

        costDomain.setAmount(wageCostDto.getAmount());
        costDomain.setDic(wageCostDto.getCurrency());
        costDomain.setSourceFrom(wageCostDto.getSourceFrom());

        BigDecimal toRmbRate = null;
        if ("CNY".equals(wageCostDto.getCurrency())) {
            toRmbRate = BigDecimal.ONE;
            costDomain.setAmountRmb(wageCostDto.getAmount());
        } else {
            toRmbRate = CurUtils.getCur(wageCostDto.getCurrency(), "CNY", getExchangeRateApi);
            costDomain.setAmountRmb(wageCostDto.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        costDomain.setToRmbRate(toRmbRate);


        UserDomain user = userDao.selectByuserid(wageCostDto.getUserId());
        if (user == null) {
            throw new RuntimeException("费用系统中没有该用户信息，请先登录一次费用系统再进行推送！");
        } else {
            costDomain.setCreateUserid(user.getUserid());
            costDomain.setCreateUsercode(user.getUsercode());
            costDomain.setCreateUsername(user.getUsername());
            costDomain.setCreateTime(new Date());
        }
        //写入费用单
        costDao.insert(costDomain);

        //写入费用单详情
        CostDetailDomain costDetailDomain = new CostDetailDomain();

        // 文件上传的路径
        String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + costDomain.getCostNo() + "/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(wageCostDto.getFileUrl(), filePath);

        BeanUtils.copyProperties(costDomain, costDetailDomain);
        costDetailDomain.setDetailNo(costNo + "-1");
        costDetailDomain.setFilePath(path);
        costDetailDao.insert(costDetailDomain);


        CostLogDomain costLogDomain = new CostLogDomain();
        costLogDomain.setCostNo(costNo);
        costLogDomain.setUpdateUserid(user.getUserid());
        costLogDomain.setUpdateUsername(user.getUsername());
        costLogDomain.setUpdateTime(new Date());
        costLogDomain.setUpdateNote("老板已经审批通过了");
        costLogDomain.setUpdateUsercode(user.getUsercode());
        costLogDao.insert(costLogDomain);

        return costNo;
    }
}
