package com.blt.other.other_cost.controller;

import com.blt.other.other_auth.service.UserService;
import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_commons.utils.PathUtil;
import com.blt.other.other_cost.service.CostDetailService;
import com.blt.other.other_cost.service.CostLogService;
import com.blt.other.other_cost.service.CostService;
import com.blt.other.other_cost.service.CostTypeKindService;
import com.blt.other.other_cost.utils.CostFileUtil;
import com.blt.other.other_database.model.CostDetailDomain;
import com.blt.other.other_database.model.CostTypeKindDomain;
import com.blt.other.other_database.model.UserDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/cost/detail")
public class CostDetailController {

    @Autowired
    private CostDetailService costDetailService;

    @Autowired
    private CostTypeKindService costTypeKindService;

    @Autowired
    private CostService costService;
    @Autowired
    private CostLogService costLogService;
    @Autowired
    private UserService userService;

    @PostMapping("/getCostDetailList")
    public Map<String, Object> getCostDetailList(HttpServletResponse response, HttpServletRequest request, Integer userId) {
        AxiosUtil.setCors(response, request);

        String costNo = request.getParameter("costNo");
        List<CostDetailDomain> costDetailListByCostNo = costDetailService.getCostDetailListByCostNo(costNo);
        Map<String, Object> result = new HashMap<>();

        UserDomain user = userService.findByUserid(userId);

        for (CostDetailDomain detail : costDetailListByCostNo) {
            if (detail != null && costDetailListByCostNo.size() > 0) {
                //类型标题  大类
                String typeName = detail.getTypeName();
                //种类标题 小类
                String kindName = detail.getKindName();
                if ((typeName.contains("工资") ||
                        kindName.contains("工资")) &&
                        !(user.getUseraccount().equals("程文爱")
                                || user.getUseraccount().equals("苏佩虹")
                                || user.getUseraccount().equals("张晓雯")
                                || user.getUseraccount().equals("王埕")
                                || user.getUseraccount().equals("赵伟铭")
                                || user.getUseraccount().equals("李静雯")
                                || user.getUseraccount().equals("董梓玲")
                                || user.getUseraccount().equals("简金源")
                                || user.getUseraccount().equals("廖文珊")
                                || user.getUseraccount().equals("李燕霞")
                                || user.getUseraccount().equals("黄晔")
                                || user.getUseraccount().equals("唐衍芬")
                                || user.getUseraccount().equals("罗贞")
                                || detail.getCreateUsername().equals(user.getUseraccount()))) {
                    detail.setFilePath("");
                }
                if (detail.getFilePath() == null) {
                    detail.setFilePath("");
                }
            }
        }

        result.put("costDetails", costDetailListByCostNo);
        return result;
    }

    @GetMapping("download")
    public ResponseEntity<InputStreamResource> download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String detailNo = request.getParameter("detailNo");
        CostDetailDomain detail = costDetailService.getCostDetailByDetailNo(detailNo);
        String filePath = null;
        String fileName = null;
        if (null != detail) {
            filePath = detail.getFilePath();
            if (null != filePath) {
                String[] split = filePath.split("&");
                if (null != split && split.length >= 1) {
                    fileName = split[split.length - 1];
                }
            }
        } else {
            return null;
        }

        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }

    @GetMapping("/getDetailByNo")
    public Map<String, Object> getDetailByNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String detailNo = request.getParameter("detailNo");
        CostDetailDomain costDetailByDetailNo = costDetailService.getCostDetailByDetailNo(detailNo);
        Map<String, Object> result = new HashMap<>();
        result.put("detail", costDetailByDetailNo);
        if (null != costDetailByDetailNo.getFilePath() && !costDetailByDetailNo.getFilePath().isEmpty()) {
            String filePath = costDetailByDetailNo.getFilePath();
            int i = filePath.lastIndexOf("&");
            String substring = filePath.substring(i + 1, filePath.length());
            result.put("fileName", substring);
        }
        return result;
    }

    @PostMapping("/resetItem/noFile")
    public Map<String, Object> resetNoFile(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        CostDetailDomain domain = createDomain(request);
        String delecteFile = request.getParameter("delecteFile");
        boolean b = Boolean.parseBoolean(delecteFile);
        if (b) {
            costDetailService.deleteFilePath(domain.getDetailNo());
        }
        Map<String, Object> result = new HashMap<>();
        result.put("success", true);

        // 判断是否更改了费用小类
//        String changeKindStr = request.getParameter("changeKind");
//        boolean changeKind = Boolean.parseBoolean(changeKindStr);
//        if (changeKind) {
        // 判断更改的费用小类是否已经存在
//            result = checkResetKind(result, domain);
//            if (!(boolean) result.get("success")) {
//                return result;
//            }
//        }

        Integer update = costDetailService.update(domain);
        if (null != update && update >= 1) {
            // 更新费用单信息
            costService.resetCost(domain.getCostNo());
        }
        result.put("detail", domain);
        return result;
    }

    @PostMapping("/resetItem/file")
    public Map<String, Object> resetFile(HttpServletResponse response, HttpServletRequest request, @RequestParam("fileSelect2") MultipartFile file) {
        AxiosUtil.setCors(response, request);
        CostDetailDomain domain = createDomain(request);

        // 文件上传的路径
        String filePath = PathUtil.getBasePath() + PathUtil.getPath("cost/" + domain.getDetailNo() + "/");
        // 调用工具类执行保存，并返回 path
        String path = CostFileUtil.upload(file, filePath);
        domain.setFilePath(path);

        Map<String, Object> result = new HashMap<>();
        result.put("success", true);

        // 判断是否更改了费用小类
//        String changeKindStr = request.getParameter("changeKind");
//        boolean changeKind = Boolean.parseBoolean(changeKindStr);
//        if (changeKind) {
        // 判断更改的费用小类是否已经存在
//            result = checkResetKind(result, domain);
//            if (!(boolean) result.get("success")) {
//                return result;
//            }
//        }

        Integer update = costDetailService.update(domain);
        if (null != update && update >= 1) {
            result.put("detail", domain);
        }
        return result;
    }

//    private Map<String, Object> checkResetKind(Map<String, Object> result, CostDetailDomain domain) {
//        CostDetailDomain costDetailDomain = costDetailService.getByCostNoAndKindNo(domain);
//        if (null != costDetailDomain && null != costDetailDomain.getDetailNo()){
//            result.put("success",false);
//            result.put("msg","该费用单已存在 "+domain.getKindName()+" ，请重新选择或取消操作");
//        }
//        return result;
//    }

    private CostDetailDomain createDomain(HttpServletRequest request) {
        CostDetailDomain domain = new CostDetailDomain();
        String costReason = request.getParameter("costReason");
        String amount = request.getParameter("amount");
        String kindNo = request.getParameter("kindNo");
        String detailNo = request.getParameter("detailNo");
        String costNo = request.getParameter("costNo");

        domain.setCostReason(costReason);
        domain.setAmount(new BigDecimal(amount));
        domain.setKindNo(kindNo);
//        domain.setDic(detailNo);
        domain.setCostNo(costNo);
        domain.setDetailNo(detailNo);

        CostTypeKindDomain kindByKindNo = costTypeKindService.getKindByKindNo(kindNo);
        domain.setKindName(kindByKindNo.getKindName());
        return domain;
    }

    @GetMapping("/getCostLogs")
    public Map<String, Object> getCostLogs(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String costNo = request.getParameter("costNo");
        List<String> costLogs = costLogService.getListLogs(costLogService.getListByCostNo(costNo));
        Map<String, Object> result = new HashMap<>();
        result.put("costLogs", costLogs);
        return result;
    }

}
