package com.blt.other.module.cost.controller.cost;

import com.bailuntec.common.JsonUtilByFsJson;
import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostListPrintDto;
import com.bailuntec.cost.api.response.CostResult;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.blt.other.common.util.AxiosUtil;
import com.blt.other.common.util.MyMapperUtil;
import com.blt.other.common.util.PathUtil;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dto.CostApiDto;
import com.blt.other.module.cost.dto.CostPageResult;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostExportService;
import com.blt.other.module.cost.service.CostListSearchService;
import com.blt.other.module.cost.service.CostLogService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.service.impl.cost.CostServiceFactory;
import com.blt.other.module.cost.service.impl.costcheck.*;
import com.blt.other.module.cost.vo.*;
import com.blt.other.module.database.model.CostExpDomain;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 11:31 上午
 */
@RequestMapping("/cost")
@RestController
@Api(tags = "费用单接口")
public class CostController {


    private CostService costService;
    @Resource
    CostListSearchService costListSearchService;
    @Resource
    CostExportService costExportService;
    @Resource
    CostLogService costLogService;
    @Resource
    CostDao costDao;

    @ApiOperation("获取前端要打印的费用单列表")
    @PostMapping("/list/print/list")
    public CostApiDto.PrintListResp printList(@RequestBody CostListPrintVo costListPrintVo) {
        costService = CostServiceFactory.getCostService();

        List<CostListPrintDto> listPrintDtos = costService.printList(costListPrintVo.getPrintNos());
        CostApiDto.PrintListResp resp = new CostApiDto.PrintListResp();
        resp.setSuccess(true);
        resp.setPrintList(listPrintDtos);
        return resp;
    }


    @ApiOperation("搜索")
    @PostMapping("/list/search/key")
    public CostApiDto.GetByKeyResp getByKey(@RequestParam Integer pageNum,
                                            @RequestParam Integer pageSize,
                                            @RequestParam String key) {
        costService = CostServiceFactory.getCostService();
        return costListSearchService.searchByKey(key, pageNum, pageSize);
    }

    @ApiOperation("搜索？")
    @PostMapping("/list/search/keys")
    public CostApiDto.GetByKeyResp getByKeys(@RequestBody CostListSearchKeysVo searchKeysVo) {
        costService = CostServiceFactory.getCostService();

        if (null != searchKeysVo.getParams().getKeys().getCostForm() && 3 == searchKeysVo.getParams().getKeys().getCostForm()) {
            searchKeysVo.getParams().getKeys().setIsLend(1);
        }
        if (null != searchKeysVo.getParams().getKeys().getCostForm() && 4 == searchKeysVo.getParams().getKeys().getCostForm()) {
            searchKeysVo.getParams().getKeys().setCostForm(3);
            searchKeysVo.getParams().getKeys().setIsLend(2);
        }
        return costListSearchService.searchByKeys(searchKeysVo);

    }

    @ApiOperation("获取借支单列表")
    @GetMapping("/list/search/getLinkCost")
    public List<CostDomain> getLinkCost() {
        return costListSearchService.getLinkCost();
    }


    @ApiOperation("获取所有费用单")
    @GetMapping("/list/getAllCost")
    public CostPageResult getAllCost(@RequestParam Integer pageNum,
                                     @RequestParam Integer pageSize,
                                     @RequestParam Integer userId,
                                     @RequestParam(defaultValue = "0", required = false) Integer authType,
                                     @RequestParam(required = false) String projectTypes) {
        if (authType != 0) {
            userId = null;
        }
        costService = CostServiceFactory.getCostService();
        return costService.getAllCost(pageNum, pageSize, userId, projectTypes);
    }

    @ApiOperation("获取费用详情")
    @PostMapping("/list/getCostDetail")
    public CostResult<CostDto> getCostDetail(@RequestParam String costNo) {

        costService = CostServiceFactory.getCostService(costNo);
        CostDomain costDomain = costService.getCostByCostNo(costNo);
        return CostResult.success(costDomain.castToDto());
    }

    @ApiOperation("修改发票附件")
    @PostMapping("list/reset/resetInvoice")
    public CostApiDto.UpdateCostResp resetInvoice(@RequestParam String costNo,
                                                  @RequestParam String filePath) {

        costService = CostServiceFactory.getCostService(costNo);
        CostDomain costDomain = new CostDomain();
        costDomain.setCostNo(costNo);
        costDomain.setHasInvoice(1);
        costDomain.setFilePath(filePath);

        CostApiDto.UpdateCostResp resp = costService.updateCost(costDomain);
        costLogService.save(costNo, costDao.selectByCostNo(costNo).getCreateUserid(), "修改发票信息");
        return resp;
    }


    @ApiOperation("修改费用单信息")
    @PostMapping({"reset/resetFile", "reset/resetNoFile"})
    public CostApiDto.UpdateCostResp resetFile(@RequestBody CostDomain costDomain) {
        costService = CostServiceFactory.getCostService(costDomain);

        CostApiDto.UpdateCostResp resp = costService.updateCost(costDomain);
        costLogService.save(costDomain.getCostNo(), costDao.selectByCostNo(costDomain.getCostNo()).getCreateUserid(), "修改费用单信息");
        return resp;
    }

    @Autowired
    UnSubmitState unSubmitState;
    @Autowired
    DepartmentCheckState departmentCheckState;
    @Autowired
    FinalCheckState finalCheckState;
    @Autowired
    FinancialCheckState financialCheckState;
    @Autowired
    PayedState payedState;
    @Autowired
    RefuseState refuseState;
    @Autowired
    UnPayState unPayState;

    @ApiOperation("提交费用单")
    @PostMapping("submitAudit")
    public CostApiDto.UpdateCostResp submitAudit(@RequestParam String costNo) {
        costService = CostServiceFactory.getCostService(costNo);

        CostDomain costDomain = costService.getCostByCostNo(costNo);

        CostContext costContext = new CostContext(costNo, costDomain.getCreateUserid());
        costContext.setCostState(unSubmitState);
        costContext.handle();


        CostApiDto.UpdateCostResp resp = new CostApiDto.UpdateCostResp();
        resp.setMsg("success");
        resp.setResult(costDao.selectByCostNo(costDomain.getCostNo()));
        resp.setUpdate(1);

        return resp;
    }

    @ApiOperation("获取借支单列表")
    @GetMapping("/getAllLendCost")
    public CostApiDto.GetAllLendCostResp getAllLendCost(@RequestParam Integer createuserid) {
        costService = CostServiceFactory.getCostService();

        List<CostDto> costDtoList = costDao.selectLinkLendCost(createuserid).stream().map(CostDomain::castToDto).collect(Collectors.toList());
        CostApiDto.GetAllLendCostResp resp = new CostApiDto.GetAllLendCostResp();
        resp.setLends(costDtoList);
        return resp;
    }

    @ApiOperation("根据费用计划查询")
    @PostMapping("/getCostByCostPlanNo")
    public CostApiDto.GetCostByCostPlanNo getCostByCostPlanNo(@RequestParam String costPlanNo) {

        costService = CostServiceFactory.getCostService();

        List<CostDto> costDtoList = costService.getByCostPlanNo(costPlanNo);
        CostApiDto.GetCostByCostPlanNo result = new CostApiDto.GetCostByCostPlanNo();
        result.setCosts(costDtoList);
        return result;
    }


    @ApiOperation("审核费用单列表")
    @GetMapping("/checkCostList")
    public CostResult<IPage<CostDto>> checkCostList(CostApiDto.CheckCostListReq req) {
        costService = CostServiceFactory.getCostService();
        IPage<CostDto> page = costService.checkCostList(req);
        return CostResult.success(page);
    }

    @ApiOperation("审核费用单列表")
    @GetMapping("/checkCostCount")
    public CostResult<Long> checkCostCount(CostApiDto.CheckCostListReq req) {
        costService = CostServiceFactory.getCostService();
        Long count = costService.checkCostList(req).getTotal();
        return CostResult.success(count);
    }

    @ApiOperation("部门审核通过")
    @GetMapping("/check/departmentCheck")
    public CostResult<Void> departmentCheck(@RequestParam String costNo,
                                            @RequestParam Integer userid) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(departmentCheckState);
        costContext.handle();
        return CostResult.success();
    }

    @GetMapping("/check/departmentRefuse")
    @ApiOperation("部门审核驳回")
    public CostResult<Void> departmentCheckRefuse(@RequestParam String costNo,
                                                  @RequestParam Integer userid,
                                                  @RequestParam String rejectReason) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(departmentCheckState);
        costContext.refuse(rejectReason);

        return CostResult.success();
    }

    @GetMapping("/check/financialCheck")
    @ApiOperation("财务审核通过")
    public CostResult<Void> financialCheck(@RequestParam String costNo,
                                           @RequestParam Integer userid) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(financialCheckState);
        costContext.handle();
        return CostResult.success();
    }

    @GetMapping("/check/financialRefuse")
    @ApiOperation("财务审核驳回")
    public CostResult<Void> financialRefuse(@RequestParam String costNo,
                                            @RequestParam Integer userid,
                                            @RequestParam String rejectReason) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(financialCheckState);
        costContext.refuse(rejectReason);
        return CostResult.success();
    }

    @GetMapping("/check/finalCheck")
    @ApiOperation("最终审核通过")
    public CostResult<Void> finalCheck(@RequestParam String costNo,
                                       @RequestParam Integer userid) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(finalCheckState);
        costContext.handle();
        return CostResult.success();
    }

    @GetMapping("/check/finalRefuse")
    @ApiOperation("最终审核人驳回")
    public CostResult<Void> finalRefuse(@RequestParam String costNo,
                                        @RequestParam Integer userid,
                                        @RequestParam String rejectReason) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(finalCheckState);
        costContext.refuse(rejectReason);
        return CostResult.success();
    }

    @ApiOperation("删除费用单")
    @PostMapping("/deleted")
    public CostResult<Void> deleted(@RequestParam String costNo) {
        costService = CostServiceFactory.getCostService(costNo);

        costService.setStatus(costNo, 5);
        costLogService.save(costNo, costDao.selectByCostNo(costNo).getCreateUserid(), "作废费用单");
        return CostResult.success();
    }

    @ApiOperation("财务审核回调")
    @PostMapping({"check/ApplyCallbackUrl", "check/lendCashierCallbackUrl"})
    public CostResult<Void> applyCallbackUrl(@RequestBody ApplyCallbackUrlVo applyCallbackUrlVo) {
        String costNo = applyCallbackUrlVo.getId().toUpperCase();
        if (costNo.contains("-")) {
            costNo = costNo.split("-")[0];
        }
        costService = CostServiceFactory.getCostService(costNo);
        costService.applyCallback(applyCallbackUrlVo);
        return CostResult.success();
    }

    @ApiOperation("财务付款回调接口")
    @PostMapping(value = {"check/CashierCallbackUrl", "check/lend/CashierCallbackUrl"})
    public CostResult<Void> cashierCallbackUrl(@RequestBody CashierCallbackUrlVo cashierCallbackUrlVo) {
        String costNo = cashierCallbackUrlVo.getId().toUpperCase();
        if (costNo.contains("-")) {
            costNo = costNo.split("-")[0];
        }
        costService = CostServiceFactory.getCostService(costNo);
        costService.cashierCallback(cashierCallbackUrlVo);
        return CostResult.success();
    }

    @GetMapping(value = {"check/cashierCallbackPass/{costNo}"})
    public CostResult<Void> cashierCallbackPass(@PathVariable String costNo) {
        CashierCallbackUrlVo cashierCallbackUrlVo = new CashierCallbackUrlVo();
        cashierCallbackUrlVo.setId(costNo);
        CashierCallbackUrlDataVo cashierCallbackUrlDataVo = new CashierCallbackUrlDataVo();
        cashierCallbackUrlDataVo.setMessage("通过");
        cashierCallbackUrlDataVo.setSuccess(true);

        CashierCallbackUrlDataDataVo cashierCallbackUrlDataDataVo = new CashierCallbackUrlDataDataVo();
        cashierCallbackUrlDataDataVo.setPayid(Integer.parseInt(IdWorker.getIdStr().substring(8)));
        cashierCallbackUrlDataDataVo.setPayno(IdWorker.getIdStr());
        cashierCallbackUrlDataDataVo.setPayamount(BigDecimal.ZERO);
        cashierCallbackUrlDataDataVo.setPayuserid(3108);
        cashierCallbackUrlDataDataVo.setPayusername("陈泽凯");
        cashierCallbackUrlDataDataVo.setPaynote("");

        Paydetail paydetail = new Paydetail();
        paydetail.setCashierbankaccountid(252);
        paydetail.setCashierbankcardname("");
        paydetail.setCashierbankcard("");
        paydetail.setCashierbankcardname("");
        paydetail.setCashierunitcode("CNY");
        paydetail.setCashierunitname("人民币");
        paydetail.setCashierrate(BigDecimal.ONE);
        paydetail.setCashierpaymoney(new BigDecimal("100"));
        paydetail.setCashierpaymoneyrmb(new BigDecimal("100"));
        paydetail.setCashierservicemoneyrmb(new BigDecimal("100"));
        paydetail.setOtherordercode("");
        paydetail.setCashierannex("");
        paydetail.setCashierbankcardtype(0);
        paydetail.setCashiermothercard("");
        cashierCallbackUrlDataDataVo.setPaydetail(paydetail);

        cashierCallbackUrlDataVo.setData("\"" + JsonUtilByFsJson.beanToJson(cashierCallbackUrlDataDataVo) + "\"");
        cashierCallbackUrlVo.setData(cashierCallbackUrlDataVo);
        this.cashierCallbackUrl(cashierCallbackUrlVo);
        return CostResult.success();
    }


    @GetMapping(value = {"check/cashierCallbackReject/{costNo}"})
    public CostResult<Void> cashierCallbackReject(@PathVariable String costNo) {
        CashierCallbackUrlVo cashierCallbackUrlVo = new CashierCallbackUrlVo();
        cashierCallbackUrlVo.setId(costNo);
        CashierCallbackUrlDataVo cashierCallbackUrlDataVo = new CashierCallbackUrlDataVo();
        cashierCallbackUrlDataVo.setMessage("被驳回");
        cashierCallbackUrlDataVo.setSuccess(true);

        CashierCallbackUrlDataDataVo cashierCallbackUrlDataDataVo = new CashierCallbackUrlDataDataVo();
        cashierCallbackUrlDataDataVo.setPayid(Integer.parseInt(IdWorker.getIdStr().substring(8)));
        cashierCallbackUrlDataDataVo.setPayno(IdWorker.getIdStr());
        cashierCallbackUrlDataDataVo.setPayamount(BigDecimal.ZERO);
        cashierCallbackUrlDataDataVo.setPayuserid(3108);
        cashierCallbackUrlDataDataVo.setPayusername("陈泽凯");
        cashierCallbackUrlDataDataVo.setPaynote("");

        Paydetail paydetail = new Paydetail();
        paydetail.setCashierbankaccountid(252);
        paydetail.setCashierbankcardname("");
        paydetail.setCashierbankcard("");
        paydetail.setCashierbankcardname("");
        paydetail.setCashierunitcode("CNY");
        paydetail.setCashierunitname("人民币");
        paydetail.setCashierrate(BigDecimal.ONE);
        paydetail.setCashierpaymoney(new BigDecimal("100"));
        paydetail.setCashierpaymoneyrmb(new BigDecimal("100"));
        paydetail.setCashierservicemoneyrmb(new BigDecimal("100"));
        paydetail.setOtherordercode("");
        paydetail.setCashierannex("");
        paydetail.setCashierbankcardtype(0);
        paydetail.setCashiermothercard("");
        cashierCallbackUrlDataDataVo.setPaydetail(paydetail);

        cashierCallbackUrlDataVo.setData("\"" + JsonUtilByFsJson.beanToJson(cashierCallbackUrlDataDataVo) + "\"");
        cashierCallbackUrlVo.setData(cashierCallbackUrlDataVo);
        this.cashierCallbackUrl(cashierCallbackUrlVo);
        return CostResult.success();
    }


    @ApiOperation("修改发票")
    @PostMapping(value = "/check/lend/invoice")
    public CostApiDto.UpdateCostResp invoice(@RequestParam String costNo,
                                             @RequestParam Integer hasInvoice,
                                             @RequestParam Integer updateuserid) {

        CostDomain costDomain = new CostDomain();

        costDomain.setHasInvoice(hasInvoice);
        costDomain.setCostNo(costNo);
        CostApiDto.UpdateCostResp resp = costService.updateCost(costDomain);
        if (hasInvoice == 0) {
            costLogService.save(costNo, updateuserid, "更改发票状态为：未给");
        } else if (hasInvoice == 1) {
            costLogService.save(costNo, updateuserid, "更改发票状态为：已给");
        }
        resp.setMsg("确认发票成功!");
        return resp;
    }

    @PostMapping("/list/exportList")
    public String exportList(HttpServletResponse response, HttpServletRequest request) {
        Enumeration<String> parameterNames = request.getParameterNames();
        if (null != parameterNames && parameterNames.hasMoreElements()) {
            String s = parameterNames.nextElement();
            CostExportVo costExportVo = (CostExportVo) MyMapperUtil.getObject(s, CostExportVo.class);
            String filePath = costExportService.exportFees(costExportVo.getParams().getExportNos());
            // 保存下载记录
            CostExpDomain exp = costExportService.saveRecord(costExportVo, filePath);
            return exp.getExpNo();
        }
        return null;
    }

    @PostMapping("/list/exportListAll")
    public String exportListAll(HttpServletResponse response, HttpServletRequest request) {
        CostService costService = CostServiceFactory.getCostService();

        AxiosUtil.setCors(response, request);
        Enumeration<String> parameterNames = request.getParameterNames();

        if (null != parameterNames && parameterNames.hasMoreElements()) {
            String s = parameterNames.nextElement();
            CostExportVo costExportVo = (CostExportVo) MyMapperUtil.getObject(s, CostExportVo.class);
            List<String> exportNos;
            if (null != costExportVo.getParams().getKeys().getCostForm() && 3 == costExportVo.getParams().getKeys().getCostForm()) {
                costExportVo.getParams().getKeys().setIsLend(1);
            }
            if (null != costExportVo.getParams().getKeys().getCostForm() && 4 == costExportVo.getParams().getKeys().getCostForm()) {
                costExportVo.getParams().getKeys().setCostForm(3);
                costExportVo.getParams().getKeys().setIsLend(2);
            }
            exportNos = costDao.listCostNoAll(costExportVo);

            String filePath = costExportService.exportFees(exportNos);
            // 保存下载记录
            CostExpDomain exp = costExportService.saveRecord(costExportVo, filePath);
            return exp.getExpNo();
        }
        return null;
    }

    @GetMapping("list/download")
    public ResponseEntity<InputStreamResource> download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathNo = request.getParameter("pathNo");
        CostExpDomain exp = costExportService.getByExpNo(pathNo);
        String filePath = exp.getExpPath();
        String fileName = PathUtil.getFileName(filePath);
        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }

    @GetMapping("list/downloadCashierAnnex")
    public ResponseEntity<InputStreamResource> downCashierAnnex(HttpServletRequest request, HttpServletResponse response) throws IOException {


        String detailNo = request.getParameter("detailNo");
        CostDomain cost = costDao.selectByCostNo(detailNo);
        String filePath = null;
        String fileName = null;
        if (null != cost) {
            filePath = cost.getCashierFilePath();
            if (null != filePath) {
                fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
            }
        } else {
            return null;
        }

        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }
}
