package com.blt.other.module.cost.model;

import com.bailuntec.api.bailuntec.cw.request.PostApplyReq;
import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.ListUtil;
import com.bailuntec.common.SpringContextUtil;
import com.bailuntec.common.StringUtils;
import com.bailuntec.cost.api.dto.CostAttach;
import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostListPrintDto;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.blt.other.common.util.CurUtils;
import com.blt.other.common.util.MoneyUtil;
import com.blt.other.database.mapper.StatusMapper;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.database.model.UserDomain;
import com.blt.other.module.cost.dao.AccountingSubjectMapper;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.sys.service.UserService;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Accessors(chain = true)
@TableName(value = "cost", autoResultMap = true)
@Data
public class CostDomain implements Serializable {

    //付款费用
    public final static Integer COST_FROM_1 = 1;
    //收款费用
    public final static Integer COST_FROM_2 = 2;
    //借支/借还
    public final static Integer COST_FROM_3 = 2;

    // 0 待提交 1- 待财务审核 2待出纳付款 3被驳回 4已支付 5已作废  6-待部门审核 7-待财务审核 8-待最终审核人审核 9-人事审核 10-总经办审核 11-工厂流程审核
    public final static int STATUS_UN_SUBMIT = 0;

    public final static int STATUS_DEPARTMENT_CHECK = 6;
    public final static int STATUS_FINANCIAL_CHECK = 7;
    public final static int STATUS_FINAL_CHECK = 8;
    public final static int STATUS_HR_CHECK = 9;
    public final static int STATUS_MANAGER_CHECK = 10;
    public final static int STATUS_FACTORY_CHECK = 11;

    public final static int STATUS_UN_PAY = 2;
    public final static int STATUS_PAYED = 4;

    public final static int STATUS_REJECT = 3;
    public final static int STATUS_DELETE = 5;


    // 费用单编号
    @TableId(type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty("费用单编号")
    private String costNo;
    @ApiModelProperty("费用计划编号")
    private String costPlanNo;
    @ApiModelProperty("当前部门id")
    private Integer costDepartmentId;


    @ApiModelProperty("主体编号")
    private String companyNo;
    @ApiModelProperty("主体名称")
    private String companyName;

    @ApiModelProperty("类型编号")
    private Integer typeId;

    @ApiModelProperty("类型编号")
    private String typeNo;
    @ApiModelProperty("类型标题")
    private String typeName;
    @ApiModelProperty("类型类别")
    private String categoryName;

    @ApiModelProperty("是否管理成本")
    private Boolean isManageCost;

    @TableField(exist = false)
    @ApiModelProperty("描述")
    private String description;

    //    @TableField(exist = false)
    private Integer accountingSubjectId;

    @ApiModelProperty("会计一级科目")
    private String accountingSubjectNo;
    @ApiModelProperty("会计一级科目")
    private String accountingSubjectName;


    @ApiModelProperty("创建人id")
    private Integer createUserid;
    @ApiModelProperty("创建人名称")
    private String createUsername;
    @ApiModelProperty("创建人费用系统编号")
    private String createUsercode;

    @ApiModelProperty("费用单备注")
    private String costRemark;
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("关联父单")
    private String supCostNo;

    @ApiModelProperty("费用单状态 0 待提交 1- 待财务审核 2待出纳付款 3被驳回 4已支付 5已作废  6-待部门审核 7-待财务审核 8-待最终审核人审核")
    private Integer costStatus;

    @ApiModelProperty("文件地址")
    private String filePath;

    @ApiModelProperty("费用总金额")
    private BigDecimal amount;

    @ApiModelProperty("二级物流供应商ID")
    private Integer subLogisticsSupplierId;
    @ApiModelProperty("一级物流供应商ID")
    private Integer logisticsSupplierId;

    @ApiModelProperty("收款银行（平台）")
    private String bankName;
    @ApiModelProperty("收款账户")
    private String bankCard;
    @ApiModelProperty("收款用户名")
    private String bankCardUser;
    @ApiModelProperty("收款/付款单位")
    private String bankCompany;


    @ApiModelProperty("1 付款费用 2 收款费用 3 借支/借还")
    private Integer costForm;
    @ApiModelProperty("1 借支 2 借还")
    private Integer isLend;
    @ApiModelProperty("1 未还 2 部分还款  3 待补差额  4 结清")
    private Integer lendStatus;

    @ApiModelProperty("付款理由")
    private String costReason;
    @ApiModelProperty("驳回原因")
    private String rejectReason;


    @ApiModelProperty("借支单已还金额")
    private BigDecimal hadPay;
    @ApiModelProperty("借支单补偿金额")
    private BigDecimal compensate;
    @ApiModelProperty("冲销金额 （借支单币种）")
    private BigDecimal counteract;
    @ApiModelProperty("借还单余额 （借支单币种）")
    private BigDecimal lendBalance;
    @ApiModelProperty("对应借支单币种）")
    private String dic;


    @ApiModelProperty("借还单冲销金额 ( 支付币种 )")
    private BigDecimal payCounteract;
    @ApiModelProperty("借还单余额 （ 支付币种 ）")
    private BigDecimal payLendBalance;
    @ApiModelProperty("计划金额 （ 支付币种 ）")
    private BigDecimal payPlanAmount;
    @ApiModelProperty("支付币种")
    private String payDic;
    @ApiModelProperty("借还单 借还支付币种 -> 借支币种汇率")
    private BigDecimal payCur;

    @ApiModelProperty("0 不抵扣个税  1 抵扣个税")
    private Integer isTax;

    @ApiModelProperty("出纳系统 detailKey")
    private String detailKey;

    @ApiModelProperty("支付者用户ID")
    private Integer payUserId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("支付时间")
    private Date payTime;

    @ApiModelProperty("转人民币汇率")
    private BigDecimal toRmbRate;

    @ApiModelProperty("费用单人民币总金额")
    private BigDecimal amountRmb;

    @ApiModelProperty("公司主体value")
    private Integer companyValue;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("财务审核时间")
    private Date auditTime;

    @ApiModelProperty("费用单发票状态编号")
    private Integer hasInvoice;

    @ApiModelProperty("驳回类型")
    private Integer rejectType;

    @ApiModelProperty("财务驳回时间")
    private Date rejectTime;

    @ApiModelProperty("费用单-出纳附件")
    private String cashierFilePath;
    @ApiModelProperty("费用单-财务地址")
    private String cashierDownloadPath;

    @ApiModelProperty("费用来源 1-默认 2-WMS 3-调拨系统 4-工资系统,5-4k DSP")
    private String sourceFrom;
    @ApiModelProperty("项目")
    private String projectType;

    @ApiModelProperty("客户编号")
    private String customerNum;

    @ApiModelProperty("所属项目")
    private String project;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("所属账期")
    private Date projectDate;

    @TableField(typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty("附加字段")
    private List<CostAttach> attach;

    @ApiModelProperty("费用模版id")
    private Integer costTemplateId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("最后更新时间")
    private LocalDateTime lastModifyDate;

    @ApiModelProperty("借支单，还款申请金额，包括已还的和申请中 ，借支单币种。")
    private BigDecimal repaymentAppliedAmount;


    @ApiModelProperty("能否审核")
    @TableField(exist = false)
    private Boolean canAudit;

    @ApiModelProperty("借支单-借支类型")
    private String lendType;


    //-------------
    @TableField(exist = false)
    private CostTemplate costTemplate;

    @TableField(exist = false)
    private Integer primaryDepartmentId;

    @TableField(exist = false)
    private String primaryDepartmentName;

    @TableField(exist = false)
    private String costCurrentReviewer;

    @TableField(exist = false)
    private List<CostDetailDomain> costDetailDomainList;

    @TableField(exist = false)
    private String departmentName;

    @ApiModelProperty(value = "ns会计科目Id")
    private Integer nsAccountingSubjectId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("实际付款时间")
    private Date actualTime;


    public void setCostType(CostTypeDomain costTypeDomain) {

        this.setTypeId(costTypeDomain.getId());
        this.setTypeNo(costTypeDomain.getTypeNo());
        this.setTypeName(costTypeDomain.getTypeName());
        this.setCategoryName(costTypeDomain.getCategoryName());

        AccountingSubjectMapper accountingSubjectMapper = SpringContextUtil.getBean(AccountingSubjectMapper.class);
        AccountingSubject accountingSubject = accountingSubjectMapper.selectById(costTypeDomain.getAccountingSubjectId());


        this.setAccountingSubjectName(accountingSubject.getName());
        this.setAccountingSubjectNo(accountingSubject.getSubjectNo());
        this.setAccountingSubjectId(accountingSubject.getId());
        this.setNsAccountingSubjectId(accountingSubject.getNsAccountingSubjectId());

        this.setIsManageCost(costTypeDomain.getIsManageCost());
    }

    /**
     * 中文正则
     */
    private static final String REGEX_CHINESE = "[\u4e00-\u9fa5]";

    public PostApplyReq buildPostApplyReq() {

        CostCompanyDao costCompanyDao = SpringContextUtil.getBean(CostCompanyDao.class);
        CostCompanyDomain companyByCompanyNo = costCompanyDao.selectByNo(companyNo);


        PostApplyReq req = new PostApplyReq();
        // 公司主体(CompanyMainName)不可为空；
        req.setCompanyMainName(companyName);
        req.setTitle(costNo);

        // 币种编号(UnitCode)不可为空；
        req.setUnitCode(dic);
        // 币种名称(UnitName)不可为空；
        req.setUnitName(dic);

        // 交易对象(TradeObjectID/TradeObjectName)不可为空；
        req.setTradeObjectID(companyByCompanyNo.getValue() + "");
        req.setTradeObjectName(this.getBankCompany() + "");

        // 交易对象账户(BankNameto/BankCardto/BankCardUserto)资料不完整；
        req.setBankCardto(this.getBankCard());
        req.setBankCardUserto(this.getBankCardUser());
        req.setBankNameto(this.getBankName());

        // newOtherPurchase申请来源(SourceCode/SourceTypeCode)不可为空；
        req.setSourceCode("newCost");
        req.setSourceTypeCode("newCostType");
        // 账期 0 PayDay
        req.setPayDay(0);
        // 预计付款时间 ExpectPayTime
        req.setExpectPayTime(new Date());

        // 申请人(UserAcctID/UserAcctName)不存在；
        req.setUserAcctID("" + this.getCreateUserid());
        req.setUserAcctName("" + this.getCreateUsername());


        // 设置 detailKey
        String detailKey = this.getDetailKey();
        if (null == detailKey || !detailKey.contains("F")) {
            detailKey = this.getCostNo();
        }
        // 回调必要的key参数（DetailKey）不能为空；
        req.setDetailKey(detailKey);
        req.setTypeName(this.getTypeName());
        req.setCategoryName(this.getCategoryName());
        req.setProject(this.getProject());
        req.setProjectDate(this.getProjectDate());

        return req;
    }

    public CostListPrintDto printDto() {

        UserService userService = SpringContextUtil.getBean(UserService.class);

        CostListPrintDto print = new CostListPrintDto();
        CostDto cost = this.castToDto();
        UserDomain user = userService.findByUserid(cost.getCreateUserid());
        if (user == null) {
            print.setDepartment("");
            print.setCreateUsername(cost.getCreateUsername() + "【注销】");
        } else {
            print.setDepartment(user.getDepartmentname1());
            print.setCreateUsername(cost.getCreateUsername());
        }
        print.setId(cost.getId());
        print.setCompanyName(cost.getCompanyName());
        print.setCostNo(costNo);
        print.setCreateTime(cost.getCreateTime());
        print.setBankCompany(cost.getBankCompany());
        print.setBankCardUser(cost.getBankCardUser());
        print.setBankCard(cost.getBankCard());
        print.setCostReason(cost.getCostReason());
        print.setDic(cost.getDicDto());
        print.setAmount(cost.getAmountDto());
        print.setTxtAmount(MoneyUtil.getCnNum(cost.getAmount()));
        if (1 == cost.getCostForm()) {
            // 付款单
            print.setCostFormStr("付");
            print.setBankCompanyStr("收款单位");
            print.setBankCardUserStr("收款户名");
            print.setFeeTypeStr("付款方式");
            print.setBankCardStr("收款账户");
            print.setCostReasonStr("付款理由");
            print.setCostReason(cost.getTypeName() + "/" + cost.getAccountingSubjectName() + ";  " + cost.getCostRemark());
            // 差额单的付款理由需详细说明
            if (null != cost.getIsLend() && 2 == cost.getIsLend()) {
                print.setCostReason("【差额单（关联借支单：" + cost.getSupCostNo() + "）】 " + cost.getTypeName() + "  " + cost.getCostRemark());
            }
            print.setCostAmountStr("付款金额");
        }
        if (2 == cost.getCostForm()) {
            // 收款单
            print.setCostFormStr("收");
            print.setBankCompanyStr("付款单位");
            print.setBankCardUserStr("付款户名");
            print.setFeeTypeStr("收款方式");
            print.setBankCardStr("付款账户");
            print.setCostReasonStr("收款理由");
            print.setCostAmountStr("收款金额");
        }

        if (3 == cost.getCostForm() && 1 == cost.getIsLend()) {
            // 借支单
            print.setCostFormStr("借支");
            print.setBankCompanyStr("收款单位");
            print.setBankCardUserStr("收款户名");
            print.setFeeTypeStr("付款方式");
            print.setBankCardStr("收款账户");
            print.setCostReasonStr("付款理由");
            print.setCostAmountStr("付款金额");
        }

        if (3 == cost.getCostForm() && 2 == cost.getIsLend()) {
            // 借还单
            print.setCostFormStr("借还");
            print.setBankCompanyStr("付款单位");
            print.setBankCardUserStr("付款户名");
            print.setFeeTypeStr("收款方式");
            print.setBankCardStr("付款账户");
            print.setCostReasonStr("收款理由");
            print.setCostAmountStr("收款金额");
            print.setDic(cost.getPayDicDto());
            print.setAmount(cost.getPayPlanAmountDto());
            print.setTxtAmount(MoneyUtil.getCnNum(cost.getPayPlanAmount()));
        }
        return print;
    }

    private final static List<String> picFilter = Lists.newArrayList("png", "jpg", "bmp,", "gif");

    public CostDto castToDto() {


        CostDto costDto = new CostDto();
        BeanUtils.copyProperties(this, costDto);


        StatusMapper statusMapper = SpringContextUtil.getBean(StatusMapper.class);
        /*字典翻译*/
        costDto.setCostStatusDto(statusMapper.getStatusValue("cost_status", this.getCostStatus()));
        if (null != this.getIsLend()) {
            costDto.setIsLendDto(statusMapper.getStatusValue("is_lend", this.getIsLend()));
        }
        if (null != this.getCostForm()) {
            costDto.setCostFormDto(statusMapper.getStatusValue("cost_form", this.getCostForm()));
        }
        if (null != this.getLendStatus()) {
            costDto.setLendStatusDto(statusMapper.getStatusValue("lend_status", this.getLendStatus()));
        }
        // 抵个税
        if (1 == costDto.getCostForm()) {
            costDto.setIsTaxStr(statusMapper.getStatusValue("is_tax", costDto.getIsTax()));
        }

        // 获取文件名
        String filePath = this.getFilePath();
        if(null != filePath && filePath.startsWith("http")){
            String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
            costDto.setFileName(fileName);
        }
        else if (null != filePath && filePath.contains("&")) {
            String fileName = filePath.substring(filePath.lastIndexOf("&") + 1);
            costDto.setFileName(fileName);
        }
        // 币种
        costDto.setDicDto(CurUtils.getCurDto(costDto.getDic()));
        costDto.setPayDicDto(CurUtils.getCurDto(costDto.getPayDic()));

        DecimalFormat df = new DecimalFormat("#0.00");
        if (null != costDto.getAmount()) {
            String format = df.format(costDto.getAmount());
            costDto.setAmountDto(format);
        }
        if (null != costDto.getPayPlanAmount()) {
            String format = df.format(costDto.getPayPlanAmount());
            costDto.setPayPlanAmountDto(format);
        }
        if (StringUtils.isNotEmpty(filePath)) {
            int i = filePath.lastIndexOf('.');
            String extension = "";
            if (i > 0) {
                extension = filePath.substring(i + 1);
            }
            costDto.setIsPic(picFilter.contains(extension));
        }
        if (ListUtil.isNotEmpty(costDetailDomainList)) {
            costDto.setCostDetailList(costDetailDomainList.stream().map(CostDetailDomain::castToDto).collect(Collectors.toList()));
        }

        return costDto;
    }

    public void setCostTemplateIdByFrom() {
        if (costForm == 1) {
            this.costTemplateId = 3;
        }
        if (costForm == 2) {
            this.costTemplateId = 5;
        }
        if (costForm == 3) {
            if (lendStatus == 1) {
                this.costTemplateId = 6;
            }
            if (lendStatus == 2) {
                this.costTemplateId = 7;
            }
        }
    }
}

