package com.blt.other.module.sys.service.impl;

import com.bailuntec.common.ListUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.common.util.SessionUtils;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaDepartment;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.sys.dao.DepartmentReviewerMapper;
import com.blt.other.module.sys.dto.request.AddDepartmentReviewerReq;
import com.blt.other.module.sys.dto.request.DepartmentReviewerListReq;
import com.blt.other.module.sys.dto.request.ModifyDepartmentReviewerReq;
import com.blt.other.module.sys.dto.request.RemoveDepartmentReviewerReq;
import com.blt.other.module.sys.dto.response.DepartmentReviewerListItem;
import com.blt.other.module.sys.model.CostReviewer;
import com.blt.other.module.sys.model.DepartmentReviewer;
import com.blt.other.module.sys.service.ICostReviewerService;
import com.blt.other.module.sys.service.IDepartmentReviewerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 部门审核人 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-12-21
 */
@Slf4j
@Service
public class DepartmentReviewerServiceImpl extends ServiceImpl<DepartmentReviewerMapper, DepartmentReviewer> implements IDepartmentReviewerService {

    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    ICostReviewerService costReviewerService;
    @Resource
    OaUserMapper oaUserMapper;
    @Resource
    OaDepartmentMapper oaDepartmentMapper;

    @Override
    public IPage<DepartmentReviewerListItem> departmentReviewerList(DepartmentReviewerListReq req) {
        IPage<DepartmentReviewerListItem> page = new Page<>(req.getPageNum(), req.getPageSize());
        page = baseMapper.departmentReviewerList(page, req);
        if (ListUtil.isNotEmpty(page.getRecords())) {
            Map<Integer, List<CostReviewer>> cMap = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .in(CostReviewer::getReferId, page.getRecords().stream().map(DepartmentReviewerListItem::getId).collect(Collectors.toList())))
                    .stream()
                    .collect(Collectors.groupingBy(CostReviewer::getReferId));

            page.getRecords().forEach(departmentReviewerListItem -> departmentReviewerListItem.setCostReviewerList(cMap.get(departmentReviewerListItem.getId())));

        }
        return page;
    }

    @Override
    public void modifyDepartmentReviewer(ModifyDepartmentReviewerReq req) {
        log.info("更新部门审核人配置");

        DepartmentReviewer departmentReviewer = this.getById(req.getId());
        departmentReviewer.setAutoReviewAmount(req.getAutoReviewerAmount());

        if (ListUtil.isNotEmpty(req.getDepartmentReviewerUserIdList())) {
            costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getReferId, req.getId()));

            this.saveDepartmentCostReviewer(req.getDepartmentReviewerUserIdList(), req.getId());
        }

    }

    @Override
    public void addDepartmentReviewer(AddDepartmentReviewerReq req) {
        log.info("新增部门审核人配置");

        DepartmentReviewer departmentReviewer = new DepartmentReviewer();

        departmentReviewer.setAutoReviewAmount(req.getAutoReviewAmount());

        OaDepartment primaryDepartment = oaDepartmentMapper.selectByDepartmentId(req.getPrimaryDepartmentId());
        departmentReviewer.setPrimaryDepartmentId(primaryDepartment.getDepartmentId());
        departmentReviewer.setPrimaryDepartmentName(primaryDepartment.getName());

        OaDepartment secondDepartment = oaDepartmentMapper.selectByDepartmentId(req.getPrimaryDepartmentId());
        departmentReviewer.setSecondDepartmentId(secondDepartment.getDepartmentId());
        departmentReviewer.setSecondDepartmentName(secondDepartment.getName());


        departmentReviewer.setUpdateUserId(SessionUtils.getCurrentUserId());
        departmentReviewer.setUpdateUserName(SessionUtils.getSysUser().getUserName());

        baseMapper.insert(departmentReviewer);


        this.saveDepartmentCostReviewer(req.getDepartmentReviewerUserIdList(), departmentReviewer.getId());

    }

    private void saveDepartmentCostReviewer(List<Integer> departmentReviewerUserIdList, Integer departmentReviewerId) {

        costReviewerService.saveBatch(departmentReviewerUserIdList.stream()
                .map(id -> {
                    CostReviewer costReviewer = new CostReviewer();
                    costReviewer.setReferId(departmentReviewerId);
                    costReviewer.setReviewerUserId(id);
                    costReviewer.setReviewerUserName(oaUserMapper.selectByOaUserId(id).getUserName());
                    costReviewer.setType(CostReviewer.departmentReviewer);
                    return costReviewer;
                })
                .collect(Collectors.toList()));
    }

    @Override
    public void removeDepartmentReviewer(RemoveDepartmentReviewerReq req) {
        log.info("删除部门审核人");
        baseMapper.deleteById(req.getId());
    }
}
