package com.blt.other.common.interceptor;

import com.bailuntec.common.SpringContextUtil;
import com.blt.other.common.base.SysUser;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.JwtUtil;
import com.blt.other.common.util.SessionUtils;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Component
@AllArgsConstructor
@Slf4j
public class SessionHandlerInterceptor implements HandlerInterceptor {


    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        try {
            String token = Lists.newArrayList(request.getHeader("Cookie").split(";"))
                    .stream()
                    .filter(item -> item.contains("BailunToken"))
                    .findAny()
                    .map(item -> item.replaceAll("BailunToken=", ""))
                    .orElseThrow(() -> new BizRuntimeException("400", "请先登陆"));

            SysUser sysUser = JwtUtil.validateToken(token);
            SessionUtils.putSysUser(sysUser);
        } catch (Exception ex) {

            String activeProfile = SpringContextUtil.getString("spring.profiles.active");
            if (activeProfile.equals("test")) {
                SysUser sysUser = new SysUser();
                sysUser.setOaUserId(0);
                sysUser.setUserName("sys");
                SessionUtils.putSysUser(sysUser);
                return true;
            }
            throw ex;
        }

        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        SessionUtils.removeSysUser();
    }

}
