package com.blt.other.module.cost.service.impl.costcheck;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.database.model.CostLogDomain;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.CostCurrentReviewerMapper;
import com.blt.other.module.cost.dao.CostTypeDao;
import com.blt.other.module.cost.model.ApprovalHistoryDomain;
import com.blt.other.module.cost.model.CostCurrentReviewer;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.cost.service.ApprovalHistoryService;
import com.blt.other.module.sys.model.CostReviewer;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: li.yanlin
 * @Description： 增加总经办审核，目前限定铭哥审核，超过1w（含）的非工资/物流单，可能只是暂时性，所以先hard code,后续有需求再改
 * @Date: Created in
 * @Modified by:
 */
@Component
@Scope("prototype")
public class GeneralManagerCheckState extends CostState {

    @Resource
    UnPayState unPayState;
    @Resource
    CostCurrentReviewerMapper costCurrentReviewerMapper;
    @Resource
    ApprovalHistoryService approvalHistoryService;
    @Resource
    CostTypeDao costTypeDao;

    @Override
    public void handle() {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;
        //CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_MANAGER_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }
        //小于1w的自动审核
        if (this.autoPass(costDomain)) {
            costDomain.setCostStatus(CostDomain.STATUS_UN_PAY);
            costDomain.setLastModifyDate(LocalDateTime.now());
            costDao.updateById(costDomain);

            List<CostCurrentReviewer> costCurrentReviewerList = costCurrentReviewerMapper.selectByCostNo(costDomain.getCostNo());
            costLogService.saveByManage(costDomain.getCostNo(), "总经办自动审核通过,当前审核人:" + costCurrentReviewerList.stream().map(CostCurrentReviewer::getUsername)
                    .collect(Collectors.joining(",")), CostLogDomain.MANAGER_AUTO_PASS);
            //流转状态
            nextState(unPayState);
            //发布到总线尝试下个环节的自动审核
            //costSubscribe.subscribe(costContext);

            //通知财务系统
            costContext.costService.toFinancial(costDomain);
            return;

        }
        if (currentUserId != null) {
            //目前限定铭哥能审核
            if (currentUserId == 681 || currentUserId == 2346) {
                //大于等于1w需要铭哥审批
                if (costDomain.getAmountRmb().compareTo(new BigDecimal("10000")) >= 0) {
                    costDomain.setCostStatus(CostDomain.STATUS_UN_PAY);
                    costDomain.setLastModifyDate(LocalDateTime.now());
                    costDao.updateById(costDomain);

                    List<CostCurrentReviewer> costCurrentReviewerList = costCurrentReviewerMapper.selectByCostNo(costDomain.getCostNo());
                    costLogService.saveByManage(costDomain.getCostNo(), "总经办审核通过,当前审核人:" + costCurrentReviewerList.stream().map(CostCurrentReviewer::getUsername)
                            .collect(Collectors.joining(",")), CostLogDomain.MANAGER_MANUAL_PASS);
                    //流转状态
                    nextState(unPayState);
                    //发布到总线尝试下个环节的自动审核
                    //costSubscribe.subscribe(costContext);

                    //通知财务系统
                    costContext.costService.toFinancial(costDomain);
                    return;
                }
            } else {
                throw new BizRuntimeException("current user no authority");
            }
        }
    }

    @Override
    public void refuse(String rejectReason) {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;

        CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_MANAGER_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //人工审核通过
        if (currentUserId == 681 || currentUserId == 2346) {
            ApprovalHistoryDomain approvalHistoryDomain = ApprovalHistoryDomain.builder()
                    .approvalUserId(currentUserId)
                    .approvalTime(LocalDateTime.now())
                    .costStatus(costDomain.getCostStatus())
                    .costNo(costDomain.getCostNo())
                    .isPassed(false)
                    .build();
            approvalHistoryService.save(approvalHistoryDomain);
            costContext.costService.reject(costDomain.getCostNo());
            costLogService.save(costDomain.getCostNo(), currentUserId, "总经办审核拒绝,理由:" + rejectReason, CostLogDomain.TYPE_UPDATE);
        } else {
            throw new BizRuntimeException("current user no authority");
        }
    }

    @Override
    public void updateCurrentReviewer() {
        CostDomain costDomain = costContext.costDomain;

        //只查铭哥的ID
        OaUser user = oaUserMapper.selectByOaUserId(681);

        List<CostReviewer> costReviewerList = new ArrayList<>();
        costReviewerList.add(CostReviewer.builder()
                .reviewerUserId(user.getOaUserId())
                .reviewerUserName(user.getUserName())
                .build());
        costCurrentReviewerService.updateByCostNoAndReviewer(costDomain.getCostNo(), costReviewerList);
//        costLogService.save(costDomain.getCostNo(), costContext.currentUserId, "最终审核人:" + costReviewerList.stream().map(CostReviewer::getReviewerUserName).collect(Collectors.joining(",")));

    }

    private boolean autoPass(CostDomain costDomain) {
        if (costDomain.getAmountRmb().compareTo(new BigDecimal("10000")) < 0) {
            return true;
        }
        if (costDomain.getCostForm().equals(2)) {
            //收款不需要审核
            return true;
        }
        CostTypeDomain costTypeDomain = costTypeDao.selectByNo(costDomain.getTypeNo());
        if (costTypeDomain.getTypeName().contains("工资") || costTypeDomain.getTypeName().contains("物流")) {
            return true;
        }
        return false;
    }
}
