package com.blt.other.module.cost.controller;

import com.bailuntec.common.JsonUtilByFsJson;
import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostListPrintDto;
import com.bailuntec.cost.api.response.CostResult;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.common.annotation.LoginIgnore;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dto.request.AllCheckCostListReq;
import com.blt.other.module.cost.dto.request.CheckCostListReq;
import com.blt.other.module.cost.dto.request.CostQueryPageReq;
import com.blt.other.module.cost.dto.response.GetAllLendCostResp;
import com.blt.other.module.cost.dto.response.GetCostByCostPlanNoResp;
import com.blt.other.module.cost.dto.response.PrintListResp;
import com.blt.other.module.cost.dto.response.UpdateCostResp;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostListSearchService;
import com.blt.other.module.cost.service.CostLogService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.service.impl.cost.CostServiceFactory;
import com.blt.other.module.cost.service.impl.costcheck.*;
import com.blt.other.module.cost.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 11:31 上午
 */
@RequestMapping("/cost")
@RestController
@Api(tags = "费用单接口")
public class CostController {

    @Resource
    private CostService costService;
    @Resource
    private CostLogService costLogService;
    @Resource
    private UnSubmitState unSubmitState;
    @Resource
    private DepartmentCheckState departmentCheckState;
    @Resource
    private FinalCheckState finalCheckState;
    @Resource
    private FinancialCheckState financialCheckState;
    @Resource
    private HrCheckState hrCheckState;
    @Resource
    private GeneralManagerCheckState generalManagerCheckState;
    @Resource
    CostListSearchService costListSearchService;
    @Resource
    CostDao costDao;

    @Deprecated
    @ApiOperation("获取借支单列表")
    @GetMapping("/getAllLendCost")
    public GetAllLendCostResp getAllLendCost(@RequestParam Integer createuserid) {
        costService = CostServiceFactory.getCostService();

        List<CostDto> costDtoList = costDao.selectLinkLendCost(createuserid).stream().map(CostDomain::castToDto).collect(Collectors.toList());
        GetAllLendCostResp resp = new GetAllLendCostResp();
        resp.setLends(costDtoList);
        return resp;
    }

    @ApiOperation("获取前端要打印的费用单列表")
    @PostMapping("/list/print/list")
    public PrintListResp printList(@RequestBody CostListPrintVo costListPrintVo) {
        costService = CostServiceFactory.getCostService();

        List<CostListPrintDto> listPrintDtos = costService.printList(costListPrintVo.getPrintNos());
        PrintListResp resp = new PrintListResp();
        resp.setSuccess(true);
        resp.setPrintList(listPrintDtos);
        return resp;
    }


    @ApiOperation("分页查询费用单")
    @PostMapping("/queryPage")
    public CostResult<Page<CostDto>> queryPage(@RequestBody CostQueryPageReq req) {
        Page<CostDomain> costDaoPage = costService.queryPage(req);
        return CostResult.success((Page<CostDto>) costDaoPage.convert(CostDomain::castToDto));
    }

    @ApiOperation("获取借支单列表")
    @GetMapping("/list/search/getLinkCost")
    public List<CostDomain> getLinkCost() {
        return costListSearchService.getLinkCost();
    }

    @ApiOperation("获取费用详情")
    @PostMapping("/list/getCostDetail")
    public CostResult<CostDto> getCostDetail(@RequestParam String costNo) {

        costService = CostServiceFactory.getCostService(costNo);
        CostDomain costDomain = costService.getCostByCostNo(costNo);
        return CostResult.success(costDomain.castToDto());
    }

    @ApiOperation("修改发票附件")
    @PostMapping("list/reset/resetInvoice")
    public UpdateCostResp resetInvoice(@RequestParam String costNo,
                                       @RequestParam String filePath) {

        costService = CostServiceFactory.getCostService(costNo);
        CostDomain costDomain = costService.getCostByCostNo(costNo);
        costDomain.setCostNo(costNo);
        costDomain.setHasInvoice(1);
        costDomain.setFilePath(filePath);

        UpdateCostResp resp = costService.updateCost(costDomain);
        costLogService.save(costNo, costService.getCostByCostNo(costNo).getCreateUserid(), "修改发票信息");
        return resp;
    }

    @ApiOperation("修改费用单信息")
    @PostMapping({"reset/resetFile", "reset/resetNoFile"})
    public UpdateCostResp resetFile(@RequestBody CostDomain costDomain) {
        costService = CostServiceFactory.getCostService(costDomain);

        UpdateCostResp resp = costService.updateCost(costDomain);
        costLogService.save(costDomain.getCostNo(), costService.getCostByCostNo(costDomain.getCostNo()).getCreateUserid(), "修改费用单信息");
        return resp;
    }

    @ApiOperation("提交费用单")
    @PostMapping("submitAudit")
    public UpdateCostResp submitAudit(@RequestParam String costNo) {
        costService = CostServiceFactory.getCostService(costNo);

        CostDomain costDomain = costService.getCostByCostNo(costNo);

        CostContext costContext = new CostContext(costNo, costDomain.getCreateUserid());
        costContext.setCostState(unSubmitState);
        costContext.handle();


        UpdateCostResp resp = new UpdateCostResp();
        resp.setMsg("success");
        resp.setResult(costService.getCostByCostNo(costDomain.getCostNo()));
        resp.setUpdate(1);

        return resp;
    }

    /**
     * 批量提交费用单
     * @param costNos
     * @return
     */
    @ApiOperation("提交费用单")
    @PostMapping("batchSubmitAudit")
    public UpdateCostResp batchSubmitAudit(@RequestParam(name = "costNos") List<String> costNos) {
        for (String costNo : costNos) {
            costService = CostServiceFactory.getCostService(costNo);

            CostDomain costDomain = costService.getCostByCostNo(costNo);

            CostContext costContext = new CostContext(costNo, costDomain.getCreateUserid());
            costContext.setCostState(unSubmitState);
            costContext.handle();
        }


        UpdateCostResp resp = new UpdateCostResp();
        resp.setMsg("success");
        resp.setUpdate(1);

        return resp;
    }

    @ApiOperation("根据费用计划查询")
    @PostMapping("/getCostByCostPlanNo")
    public GetCostByCostPlanNoResp getCostByCostPlanNo(@RequestParam String costPlanNo) {

        costService = CostServiceFactory.getCostService();

        List<CostDto> costDtoList = costService.getByCostPlanNo(costPlanNo);
        GetCostByCostPlanNoResp result = new GetCostByCostPlanNoResp();
        result.setCosts(costDtoList);
        return result;
    }

    @ApiOperation("待审核费用单列表")
    @GetMapping("/checkCostList")
    public CostResult<IPage<CostDto>> checkCostList(CheckCostListReq req) {
        costService = CostServiceFactory.getCostService();
        IPage<CostDto> page = costService.checkCostList(req);
        return CostResult.success(page);
    }

    @ApiOperation("待我审核列表")
    @GetMapping("/checkCostAllList")
    public CostResult<IPage<CostDto>> checkCostAllList(AllCheckCostListReq req) {
        costService = CostServiceFactory.getCostService();
        IPage<CostDto> page = costService.checkCostAllList(req);
        return CostResult.success(page);
    }

    @ApiOperation("审核费用单列表")
    @GetMapping("/checkCostCount")
    public CostResult<Long> checkCostCount(CheckCostListReq req) {
        costService = CostServiceFactory.getCostService();
        Long count = costService.checkCostList(req).getTotal();
        req.setType(1);
        Long count1 = costService.checkCostList(req).getTotal();
        req.setType(4);
        Long count2 = costService.checkCostList(req).getTotal();
        return CostResult.success(count + count1 + count2);
    }

    @ApiOperation("部门审核通过")
    @GetMapping("/check/departmentCheck")
    public CostResult<Void> departmentCheck(@RequestParam String costNo,
                                            @RequestParam Integer userid) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(departmentCheckState);
        costContext.handle();
        return CostResult.success();
    }

    @GetMapping("/check/departmentRefuse")
    @ApiOperation("部门审核驳回")
    public CostResult<Void> departmentCheckRefuse(@RequestParam String costNo,
                                                  @RequestParam Integer userid,
                                                  @RequestParam String rejectReason) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(departmentCheckState);
        costContext.refuse(rejectReason);

        return CostResult.success();
    }

    @GetMapping("/check/financialCheck")
    @ApiOperation("财务审核通过")
    public CostResult<Void> financialCheck(@RequestParam String costNo,
                                           @RequestParam Integer userid) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(financialCheckState);
        costContext.handle();
        return CostResult.success();
    }

    @GetMapping("/check/financialRefuse")
    @ApiOperation("财务审核驳回")
    public CostResult<Void> financialRefuse(@RequestParam String costNo,
                                            @RequestParam Integer userid,
                                            @RequestParam String rejectReason) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(financialCheckState);
        costContext.refuse(rejectReason);
        return CostResult.success();
    }

    @GetMapping("/check/finalCheck")
    @ApiOperation("最终审核通过")
    public CostResult<Void> finalCheck(@RequestParam String costNo,
                                       @RequestParam Integer userid) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(finalCheckState);
        costContext.handle();
        return CostResult.success();
    }

    @GetMapping("/check/finalRefuse")
    @ApiOperation("最终审核人驳回")
    public CostResult<Void> finalRefuse(@RequestParam String costNo,
                                        @RequestParam Integer userid,
                                        @RequestParam String rejectReason) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(finalCheckState);
        costContext.refuse(rejectReason);
        return CostResult.success();
    }

    @GetMapping("/check/managerCheck")
    @ApiOperation("总经办审核通过")
    public CostResult<Void> managerCheck(@RequestParam String costNo,
                                       @RequestParam Integer userid) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(generalManagerCheckState);
        costContext.handle();
        return CostResult.success();
    }

    @GetMapping("/check/managerRefuse")
    @ApiOperation("总经办审核人驳回")
    public CostResult<Void> managerRefuse(@RequestParam String costNo,
                                        @RequestParam Integer userid,
                                        @RequestParam String rejectReason) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(generalManagerCheckState);
        costContext.refuse(rejectReason);
        return CostResult.success();
    }

    @GetMapping("/check/hrCheck")
    @ApiOperation("行政审核通过")
    public CostResult<Void> hrCheck(@RequestParam String costNo,
                                    @RequestParam Integer userid) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(hrCheckState);
        costContext.handle();
        return CostResult.success();
    }

    @GetMapping("/check/hrCheckRefuse")
    @ApiOperation("行政审核驳回")
    public CostResult<Void> hrCheckRefuse(@RequestParam String costNo,
                                          @RequestParam Integer userid,
                                          @RequestParam String rejectReason) {
        CostContext costContext = new CostContext(costNo, userid);
        costContext.setCostState(hrCheckState);
        costContext.refuse(rejectReason);
        return CostResult.success();
    }

    @ApiOperation("删除费用单")
    @PostMapping("/list/deleted")
    public CostResult<Void> deleted(@RequestParam String costNo) {
        costService = CostServiceFactory.getCostService(costNo);

        costService.setStatus(costNo, 5);


        //释放已申请的金额
        CostDomain costDomain = costService.getCostByCostNo(costNo);
        if (costDomain.getCostForm().equals(3) && costDomain.getIsLend().equals(2)) {
            CostDomain supCost = costService.getCostByCostNo(costDomain.getSupCostNo());

            supCost.setRepaymentAppliedAmount(supCost.getRepaymentAppliedAmount().subtract(costDomain.getAmount()));
            supCost.setLastModifyDate(LocalDateTime.now());
            costDao.updateById(supCost);
        }

        costLogService.save(costNo, costService.getCostByCostNo(costNo).getCreateUserid(), "作废费用单");
        return CostResult.success();
    }

    @LoginIgnore
    @ApiOperation("财务审核回调")
    @PostMapping({"check/ApplyCallbackUrl", "check/lendCashierCallbackUrl"})
    public Map<String, Object> applyCallbackUrl(@RequestBody ApplyCallbackUrlVo applyCallbackUrlVo) {
        String costNo = applyCallbackUrlVo.getId().toUpperCase();
        if (costNo.contains("-")) {
            costNo = costNo.split("-")[0];
        }
        costService = CostServiceFactory.getCostService(costNo);
        costService.applyCallback(applyCallbackUrlVo);

        Map<String, Object> result = new HashMap<>();
        result.put("success", true);
        result.put("msg", "success");
        result.put("result", true);
        return result;
    }

    @Value("${spring.profiles.active}")
    String profile;

    @LoginIgnore
    @ApiOperation("财务付款回调接口")
    @PostMapping(value = {"check/CashierCallbackUrl", "check/lend/CashierCallbackUrl"})
    public Map<String, Object> cashierCallbackUrl(@RequestBody CashierCallbackUrlVo cashierCallbackUrlVo) {

        Map<String, Object> result = new HashMap<>();
        result.put("success", true);
        result.put("msg", "success");
        result.put("result", true);

        String costNo = cashierCallbackUrlVo.getId().toUpperCase();
        if ((!(costNo.startsWith("F") || costNo.startsWith("SF")))
                && profile.equals("prod")) {
            return result;
        }
        if (costNo.contains("-")) {
            costNo = costNo.split("-")[0];
        }
        costService = CostServiceFactory.getCostService(costNo);
        costService.cashierCallback(cashierCallbackUrlVo);

        return result;
    }

    @ApiOperation("mock财务付款回调成功")
    @GetMapping(value = {"check/cashierCallbackPass/{costNo}"})
    public CostResult<Void> cashierCallbackPass(@PathVariable String costNo) {
        CashierCallbackUrlVo cashierCallbackUrlVo = new CashierCallbackUrlVo();
        cashierCallbackUrlVo.setId(costNo);
        CashierCallbackUrlDataVo cashierCallbackUrlDataVo = new CashierCallbackUrlDataVo();
        cashierCallbackUrlDataVo.setMessage("通过");
        cashierCallbackUrlDataVo.setSuccess(true);

        CashierCallbackUrlDataDataVo cashierCallbackUrlDataDataVo = new CashierCallbackUrlDataDataVo();
        cashierCallbackUrlDataDataVo.setPayid(Integer.parseInt(IdWorker.getIdStr().substring(0, 8)));
        cashierCallbackUrlDataDataVo.setPayno(IdWorker.getIdStr());
        cashierCallbackUrlDataDataVo.setPayamount(BigDecimal.ZERO);
        cashierCallbackUrlDataDataVo.setPayuserid(3108);
        cashierCallbackUrlDataDataVo.setPayusername("陈泽凯");
        cashierCallbackUrlDataDataVo.setPaynote("");

        Paydetail paydetail = new Paydetail();
        paydetail.setCashierbankaccountid(252);
        paydetail.setCashierbankcardname("");
        paydetail.setCashierbankcard("");
        paydetail.setCashierbankcardname("");
        paydetail.setCashierunitcode("CNY");
        paydetail.setCashierunitname("人民币");
        paydetail.setCashierrate(BigDecimal.ONE);
        paydetail.setCashierpaymoney(new BigDecimal("100"));
        paydetail.setCashierpaymoneyrmb(new BigDecimal("100"));
        paydetail.setCashierservicemoneyrmb(new BigDecimal("100"));
        paydetail.setOtherordercode("");
        paydetail.setCashierannex("");
        paydetail.setCashierbankcardtype(0);
        paydetail.setCashiermothercard("");
        cashierCallbackUrlDataDataVo.setPaydetail(paydetail);

        cashierCallbackUrlDataVo.setData(JsonUtilByFsJson.beanToJson(cashierCallbackUrlDataDataVo));
        cashierCallbackUrlVo.setData(cashierCallbackUrlDataVo);
        this.cashierCallbackUrl(cashierCallbackUrlVo);
        return CostResult.success();
    }

    @ApiOperation("mock财务付款回调拒绝")
    @GetMapping(value = {"check/cashierCallbackReject/{costNo}"})
    public CostResult<Void> cashierCallbackReject(@PathVariable String costNo) {
        CashierCallbackUrlVo cashierCallbackUrlVo = new CashierCallbackUrlVo();
        cashierCallbackUrlVo.setId(costNo);
        CashierCallbackUrlDataVo cashierCallbackUrlDataVo = new CashierCallbackUrlDataVo();
        cashierCallbackUrlDataVo.setMessage("被驳回");
        cashierCallbackUrlDataVo.setSuccess(true);

        CashierCallbackUrlDataDataVo cashierCallbackUrlDataDataVo = new CashierCallbackUrlDataDataVo();
        cashierCallbackUrlDataDataVo.setPayid(Integer.parseInt(IdWorker.getIdStr().substring(0, 8)));
        cashierCallbackUrlDataDataVo.setPayno(IdWorker.getIdStr());
        cashierCallbackUrlDataDataVo.setPayamount(BigDecimal.ZERO);
        cashierCallbackUrlDataDataVo.setPayuserid(3108);
        cashierCallbackUrlDataDataVo.setPayusername("陈泽凯");
        cashierCallbackUrlDataDataVo.setPaynote("");

        Paydetail paydetail = new Paydetail();
        paydetail.setCashierbankaccountid(252);
        paydetail.setCashierbankcardname("");
        paydetail.setCashierbankcard("");
        paydetail.setCashierbankcardname("");
        paydetail.setCashierunitcode("CNY");
        paydetail.setCashierunitname("人民币");
        paydetail.setCashierrate(BigDecimal.ONE);
        paydetail.setCashierpaymoney(new BigDecimal("100"));
        paydetail.setCashierpaymoneyrmb(new BigDecimal("100"));
        paydetail.setCashierservicemoneyrmb(new BigDecimal("100"));
        paydetail.setOtherordercode("");
        paydetail.setCashierannex("");
        paydetail.setCashierbankcardtype(0);
        paydetail.setCashiermothercard("");
        cashierCallbackUrlDataDataVo.setPaydetail(paydetail);

        cashierCallbackUrlDataVo.setData(JsonUtilByFsJson.beanToJson(cashierCallbackUrlDataDataVo));
        cashierCallbackUrlVo.setData(cashierCallbackUrlDataVo);
        this.cashierCallbackUrl(cashierCallbackUrlVo);
        return CostResult.success();
    }

    @ApiOperation("修改发票")
    @PostMapping(value = "/check/lend/invoice")
    public UpdateCostResp invoice(@RequestParam String costNo,
                                  @RequestParam Integer hasInvoice,
                                  @RequestParam Integer updateuserid) {

        costService = CostServiceFactory.getCostService(costNo);

        CostDomain costDomain = costService.getCostByCostNo(costNo);
        costService = CostServiceFactory.getCostService(costNo);

        costDomain.setHasInvoice(hasInvoice);
        costDomain.setCostNo(costNo);
        UpdateCostResp resp = costService.updateCost(costDomain);
        if (hasInvoice == 0) {
            costLogService.save(costNo, updateuserid, "更改发票状态为：未给");
        } else if (hasInvoice == 1) {
            costLogService.save(costNo, updateuserid, "更改发票状态为：已给");
        }
        resp.setMsg("确认发票成功!");
        return resp;
    }

}
