package com.blt.other.module.cost.service.impl.costplan;

import com.bailuntec.common.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.cost.model.AccountingSubject;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostPlanService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

/**
 * <p>
 * 收款单类型
 * </p>
 *
 * @author robbendev
 * @since 2020/10/16 1:25 下午
 */
@Transactional(rollbackFor = Exception.class)
@Service
public class CostPlanNewReceiptServiceImpl extends AbstractCostPlanService implements CostPlanService {

    @Override
    public void save(CostPlanDomain planDomain) {
        this.doSaveFinanceRecord(planDomain);
        this.completedCostPlan(planDomain);
        planDomain.setCostPlanStatus(0);

        CostTypeDomain costTypeDomain = costTypeDao.selectByNo(planDomain.getTypeNo());

        planDomain.setTypeId(costTypeDomain.getId());

        this.check(planDomain);
        costPlanDao.insert(planDomain);
    }

    @Override
    public void update(CostPlanDomain planDomain) {
        this.doSaveFinanceRecord(planDomain);

        this.completedCostPlan(planDomain);

        CostTypeDomain costTypeDomain = costTypeDao.selectByNo(planDomain.getTypeNo());
        AccountingSubject accountingSubject = accountingSubjectMapper.selectById(costTypeDomain.getAccountingSubjectId());

        planDomain.setTypeId(costTypeDomain.getId());
        planDomain.setTypeName(costTypeDomain.getTypeName());
        planDomain.setAccountingSubjectId(accountingSubject.getId());
        planDomain.setAccountingSubjectName(accountingSubject.getName());

        costPlanDao.update(planDomain, new LambdaQueryWrapper<CostPlanDomain>()
                .eq(CostPlanDomain::getCostPlanNo, planDomain.getCostPlanNo()));
    }

    @Override
    public Integer affirm(String costPlanNo) {
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
        if (costPlanDomain.getCostPlanStatus() != 0) {
            throw new BizRuntimeException("只能更新待确认的计划单");
        }
        costPlanDomain.setCostPlanStatus(1);
        costPlanDao.update(costPlanDomain, new LambdaQueryWrapper<CostPlanDomain>()
                .eq(CostPlanDomain::getCostPlanNo, costPlanDomain.getCostPlanNo()));

        CostDomain costDomain = planToCost(costPlanNo);
        String costNo = getCostNo();
        costDomain.setCostNo(costNo);
        costDomain.setCostStatus(0);
        costDomain.setAmount(costPlanDomain.getPlanAmount());
        BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY");
        if (BigDecimal.ZERO.compareTo(toRmbRate) == 0) {
            throw new BizRuntimeException("获取汇率异常,请重试!");
        }
        costDomain.setToRmbRate(toRmbRate);
        costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        if(StringUtils.isBlank(costDomain.getCategoryName())){
            costDomain.setCategoryName((StringUtils.isNotBlank(costDomain.getProject()) && costDomain.getProject().equals("集团") ? "管理成本" : "日常费用"));
        }
        Integer insert = costDao.insert(costDomain);

        // 记录日志
        costLogService.save(costDomain.getCostNo(), costDomain.getCreateUserid(), "由费用计划：" + costDomain.getCostPlanNo() + " 生成收款单");
        return insert;
    }
}
