package com.blt.other.module.purchasing.controller;

import com.blt.other.common.util.AxiosUtil;
import com.blt.other.common.util.PathUtil;
import com.blt.other.module.purchasing.dto.BuyListPrintDto;
import com.blt.other.module.purchasing.service.BuyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/purchasing/list")
public class PurchasingListController {

    @Autowired
    private BuyService buyService;

    @GetMapping("/getAllBuy")
    public Map<String, Object> getAllBuy(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);

        String pageNum = request.getParameter("pageNum");
        String pageSize = request.getParameter("pageSize");

        Map<String, Object> allBuyList = buyService.getAllBuyList(Integer.parseInt(pageSize), Integer.parseInt(pageNum));
        return allBuyList;
    }


    @GetMapping("/print")
    public Map<String, Object> printList(HttpServletResponse response, HttpServletRequest request,
                                         @RequestParam(name = "printBuyIds") Integer[] printBuyIds) {
        AxiosUtil.setCors(response, request);
        if (printBuyIds != null && printBuyIds.length > 0) {
            List<BuyListPrintDto> printDtoList = buyService.getBuyPrintList(printBuyIds);
            Map<String, Object> result = new HashMap<>();
            result.put("success", true);
            result.put("printList", printDtoList);
            return result;
        }
        return null;
    }

    /**
     * 采购单导出excel
     *
     * @param buyIds
     * @return
     * @throws IOException
     */
    @GetMapping("/export")
    public ResponseEntity<InputStreamResource> exportList(@RequestParam(name = "buyIds") Integer[] buyIds) throws IOException {
        String filePath = buyService.exportExcel(buyIds);
        FileSystemResource file = new FileSystemResource(filePath);
        String fileName = PathUtil.getFileName(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }
}
