package com.blt.other.module.cost.service.impl.costcheck;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.cost.model.CostCurrentReviewer;
import com.blt.other.module.cost.model.CostDomain;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:57 下午
 */
@Component
@Scope("prototype")
public class UnPayState extends CostState {

    @Override
    public void handle() {

    }

    @Override
    public void refuse(String reason) {
        throw new BizRuntimeException("unsupported operate ");
    }

    @Override
    public void updateCurrentReviewer() {
        CostDomain costDomain = costContext.costDomain;

        costCurrentReviewerService.remove(new LambdaQueryWrapper<CostCurrentReviewer>()
                .eq(CostCurrentReviewer::getCostNo, costDomain.getCostNo()));

    }
}
