package com.blt.other.module.cost.service.impl;

import com.bailuntec.common.exception.BizException;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.module.cost.dao.ApprovalHistoryMapper;
import com.blt.other.module.cost.dto.request.ApprovalHistoryReq;
import com.blt.other.module.cost.model.ApprovalHistoryDomain;
import com.blt.other.module.cost.service.ApprovalHistoryService;
import com.blt.other.module.cost.vo.ApprovalHistoryVo;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Service
public class ApprovalHistoryServiceImpl extends ServiceImpl<ApprovalHistoryMapper, ApprovalHistoryDomain> implements ApprovalHistoryService {

    @Resource
    ApprovalHistoryMapper approvalHistoryMapper;

    @Override
    public List<ApprovalHistoryVo> getApprovalHistoryList(ApprovalHistoryReq req) {
        if(req.getStartTime() == null || req.getEndTime() == null){
            throw new BizException("查询时间不可为空");
        }
        if(req.getStartTime().isAfter(req.getEndTime())){
            throw new BizException("查询起始时间不可大于查询结束时间");
        }
        return approvalHistoryMapper.getApprovalHistoryList(req);
    }
}
