package com.bailuntec.cost.api.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/22 1:51 下午
 */
@Data
public class CostDetailDto {

    @TableId(type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty("费用详情编号")
    private String detailNo;
    @ApiModelProperty("费用单编号")
    private String costNo;


    @ApiModelProperty("类型编号")
    private String typeNo;
    @ApiModelProperty("类型标题")
    private String typeName;
    @ApiModelProperty("会计一级科目")
    private String accountingSubjectNo;
    @ApiModelProperty("会计一级科目")
    private String accountingSubjectName;


    @ApiModelProperty("创建人id")
    private Integer createUserid;
    @ApiModelProperty("创建人名称")
    private String createUsername;
    @ApiModelProperty("付款理由")
    private String costReason;

    @ApiModelProperty("费用详情金额")
    private BigDecimal amount;
    @ApiModelProperty("币种")
    private String dic;
    @ApiModelProperty("借支单-借支类型")
    private String lendType;
    @ApiModelProperty("文件地址")
    private String filePath;

    @ApiModelProperty("项目")
    private String projectType;
    @ApiModelProperty("客户编号")
    private String customerNum;

    @ApiModelProperty("所属项目")
    private String project;
    @ApiModelProperty("所属账期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectDate;
}
