package com.blt.other.module.sys.service.impl;

import com.blt.other.module.auth.dao.UserDao;
import com.blt.other.module.sys.service.UserService;
import com.blt.other.module.auth.vo.UserGetByBLUserAcct;
import com.blt.other.database.model.UserDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class UserServiceImpl implements UserService {

    private static Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);

    @Autowired
    private UserDao userDao;

    @Override
    public UserDomain findOne(String usercode) {
        return userDao.select(usercode);
    }

    @Override
    public List<UserDomain> findAllUser() {
        List<UserDomain> userDomains = userDao.selectUsers();
        return userDomains;
    }

    @Override
    public Integer saveUser(UserGetByBLUserAcct userGetByBLUserAcct) {
        UserDomain userDomain = new UserDomain();
        BeanUtils.copyProperties(userGetByBLUserAcct, userDomain);
        userDomain.setCreatetime(new Date());

        UserDomain select = userDao.selectByuserid(userGetByBLUserAcct.getUserid());

        Integer result = null;
        if (null != select) {
            result = userDao.update(userDomain);
            logger.warn("修改用户信息：" + result);
        } else {
            userDomain.setIsadmin(0);
            userDomain.setIsfinansys(0);
            result = userDao.insert(userDomain);
            logger.warn("保存用户信息：" + result);
        }
        return result;
    }

    @Override
    public Integer save(UserDomain user) {
        user.setCreatetime(new Date());
        UserDomain userDomain = userDao.selectByuserid(user.getUserid());
        Integer result = userDao.insert(user);
        logger.warn("保存用户信息：" + result);
        return result;
    }

    @Override
    public Integer deleteUser(int parseInt) {
        return userDao.delete(parseInt);
    }

    @Override
    public UserDomain findByUserid(int parseInt) {
        return userDao.selectByuserid(parseInt);
    }

    @Override
    public Integer updateUser(UserDomain user) {
        return userDao.update(user);
    }

    @Override
    public void insertUser(UserDomain user) {
        userDao.insertUser(user);
    }

    @Override
    public List<UserDomain> getListByKey(String key) {
        List<UserDomain> userDomains = userDao.selectByKey(key);
        return userDomains;
    }

    @Override
    public List<UserDomain> getAllAdmins() {
        return userDao.selectAdmins();
    }

    @Override
    public List<UserDomain> getAllFinansys() {
        return userDao.selectFinansys();
    }

    @Override
    public List<UserDomain> getAllSupAdmins() {
        return userDao.selectSupAdmins();
    }

    @Override
    public List<UserDomain> getByPrimaryDepartmentId(@NonNull Integer primaryDepartmentId) {
        return userDao.getByPrimaryDepartmentId(primaryDepartmentId);
    }

    @Override
    public List<UserDomain> getByCompanyId(@NonNull Integer companyId) {
        return userDao.getByCompanyId(companyId);
    }


}
