package com.blt.other.module.cost.controller;

import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostListPrintDto;
import com.blt.other.module.auth.service.UserService;
import com.blt.other.common.util.AxiosUtil;
import com.blt.other.common.util.MoneyUtil;
import com.blt.other.common.util.MyMapperUtil;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.vo.CostListPrintVo;
import com.blt.other.module.database.model.UserDomain;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;


@Api(tags = "打印费用单")
@RestController
@RequestMapping("/cost/list/print")
public class CostListPrintController {

    @Autowired
    private CostService costService;
    @Autowired
    private UserService userService;

    @PostMapping("/list")
    public Map<String, Object> printList(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        // 获取前端要打印的费用单列表
        Enumeration<String> parameterNames = request.getParameterNames();
        if (null != parameterNames && parameterNames.hasMoreElements()) {
            String s = parameterNames.nextElement();
            CostListPrintVo printVo = (CostListPrintVo) MyMapperUtil.getObject(s, CostListPrintVo.class);
            List<String> printNos = printVo.getPrintNos();
            // 遍历获取费用单详情
            if (null != printNos && printNos.size() >= 1) {
                List<CostListPrintDto> printDtoList = new ArrayList<>();
                for (String costNo : printNos) {
                    CostListPrintDto dto = getPrintDto(costNo);
                    printDtoList.add(dto);
                }

                Map<String, Object> result = new HashMap<>();
                result.put("success", true);
                result.put("printList", printDtoList);
                return result;
            }
        }
        return null;
    }

    private CostListPrintDto getPrintDto(String costNo) {
        CostListPrintDto print = new CostListPrintDto();
        CostDto cost = costService.getCostDtoByNo(costNo);
        UserDomain user = userService.findByUserid(cost.getCreateUserid());
        if (user == null) {
            print.setDepartment("");
            print.setCreateUsername(cost.getCreateUsername() + "【注销】");
        } else {
            print.setDepartment(user.getDepartmentname1());
            print.setCreateUsername(cost.getCreateUsername());
        }
        print.setId(cost.getId());
        print.setCompanyName(cost.getCompanyName());
        //print.setDepartment(user.getDepartmentname1());
        print.setCostNo(costNo);
        print.setCreateTime(cost.getCreateTime());
        print.setBankCompany(cost.getBankCompany());
        print.setBankCardUser(cost.getBankCardUser());
        print.setBankCard(cost.getBankCard());
        print.setCostReason(cost.getCostReason());
        print.setDic(cost.getDicDto());
        print.setAmount(cost.getAmountDto());
        print.setTxtAmount(MoneyUtil.getCnNum(cost.getAmount()));
// dic='null', amount=null, txtAmount='null'}
        if (1 == cost.getCostForm()) {
            // 付款单
            print.setCostFormStr("付");
            print.setBankCompanyStr("收款单位");
            print.setBankCardUserStr("收款户名");
            print.setFeeTypeStr("付款方式");
            print.setBankCardStr("收款账户");
            print.setCostReasonStr("付款理由");
            print.setCostReason(cost.getTypeName() + "/" + cost.getKindName() + ";  " + cost.getCostRemark());
            // 差额单的付款理由需详细说明
            if (null != cost.getIsLend() && 2 == cost.getIsLend()) {
                print.setCostReason("【差额单（关联借支单：" + cost.getSupCostNo() + "）】 " + cost.getTypeName() + "  " + cost.getCostRemark());
            }
            print.setCostAmountStr("付款金额");
        }
        if (2 == cost.getCostForm()) {
            // 收款单
            print.setCostFormStr("收");
            print.setBankCompanyStr("付款单位");
            print.setBankCardUserStr("付款户名");
            print.setFeeTypeStr("收款方式");
            print.setBankCardStr("付款账户");
            print.setCostReasonStr("收款理由");
            print.setCostAmountStr("收款金额");
        }

        if (3 == cost.getCostForm() && 1 == cost.getIsLend()) {
            // 借支单
            print.setCostFormStr("借支");
            print.setBankCompanyStr("收款单位");
            print.setBankCardUserStr("收款户名");
            print.setFeeTypeStr("付款方式");
            print.setBankCardStr("收款账户");
            print.setCostReasonStr("付款理由");
            print.setCostAmountStr("付款金额");
        }

        if (3 == cost.getCostForm() && 2 == cost.getIsLend()) {
            // 借还单
            print.setCostFormStr("借还");
            print.setBankCompanyStr("付款单位");
            print.setBankCardUserStr("付款户名");
            print.setFeeTypeStr("收款方式");
            print.setBankCardStr("付款账户");
            print.setCostReasonStr("收款理由");
            print.setCostAmountStr("收款金额");
            print.setDic(cost.getPayDicDto());
            print.setAmount(cost.getPayPlanAmountDto());
            print.setTxtAmount(MoneyUtil.getCnNum(cost.getPayPlanAmount()));
        }
        return print;
    }

}
