package com.blt.other.module.cost.controller;

import com.bailuntec.cost.api.CostApi;
import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.LogisticsCostDto;
import com.bailuntec.cost.api.dto.ManageCostDto;
import com.bailuntec.cost.api.dto.WageCostDto;
import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.common.annotation.LoginIgnore;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.SneakyThrows;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

@Api(tags = "外部调用api")
@RestController
@RequestMapping("/cost/api")
public class CostApiController implements CostApi {

    @Resource
    private CostApiService costApiService;

    private static Logger logger = LoggerFactory.getLogger(CostApiController.class);


    @LoginIgnore
    @Override
    @ApiOperation("接受工资单，自动生成付款费用单到财务审核")
    @PostMapping("/pushWageCost")
    public CostResult<Void> pushWageCost(@RequestBody WageCostDto wageCostDto) throws IOException {
        logger.info("接收推送而来的工资单信息：" + wageCostDto);
        String costNo = costApiService.pushWageCost(wageCostDto);
        return CostResult.successMsg(costNo);
    }

    @LoginIgnore
    @ApiOperation("接收物流单，自动生成付款费用单到财务审核")
    @Override
    @PostMapping("/pushLogisticsCost")
    public CostResult<Void> pushLogisticsCost(@RequestBody LogisticsCostDto logisticsCostDto) throws Exception {
        logger.warn("接收推送而来的物流单信息：" + logisticsCostDto);
        String costNo = costApiService.generateLogisticsCost(CostDomain.COST_FROM_1, logisticsCostDto);
        return CostResult.successMsg(costNo);
    }

    @LoginIgnore
    @ApiOperation("吴通接收物流单，自动生成收款费用单到财务审核")
    @Override
    @PostMapping("/pushLogisticsReceipt")
    public CostResult<Void> pushLogisticsReceipt(@RequestBody LogisticsCostDto logisticsCostDto) throws Exception {
        logger.info("接收推送而来的物流单信息：" + logisticsCostDto);
        String costNo = costApiService.generateLogisticsCost(CostDomain.COST_FROM_2, logisticsCostDto);
        return CostResult.successMsg(costNo);
    }


    @LoginIgnore
    @SneakyThrows
    @ApiOperation("查询管理成本的数据")
    @Override
    @GetMapping("/manageCostList")
    public CostResult<List<ManageCostDto>> manageCostList(@RequestParam(name = "startDate", required = false) String startDateStr,
                                                          @RequestParam(name = "endDate", required = false) String endDateStr,
                                                          @RequestParam(name = "feeSuperType", required = false) String feeSuperType,
                                                          @RequestParam(name = "feeSubType", required = false) String feeSubType,
                                                          @RequestParam(name = "companyValue", required = false) Integer companyValue,
                                                          @RequestParam(name = "companyName", required = false) String companyName,
                                                          @RequestParam(name = "departmentName", required = false) String departmentName,
                                                          @RequestParam(name = "createUserId", required = false) Integer createUserId,
                                                          @RequestParam(name = "payUserId", required = false) Integer payUserId) {

//        if (!StringUtils.isEmpty(departmentName)) {
//            departmentName = departmentName.toLowerCase();
//        }
//        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
//
//        LocalDateTime startDate = LocalDateTime.parse(startDateStr, df);
//        LocalDateTime endDate = LocalDateTime.parse(endDateStr, df);
//
//        List<ManageCostDto> manageCostDtoList = costApiService.getMangeCostList(startDate, endDate, feeSuperType, feeSubType, companyValue, companyName, departmentName, createUserId, payUserId);
//        //todo
        return CostResult.success();

    }

    @LoginIgnore
    @SneakyThrows
    @ApiOperation("查询所有的物流费用单和采购单")
    @Override
    @GetMapping("/logisticsCostList")
    public CostResult<List<ManageCostDto>> logisticsCostList(@RequestParam(name = "startDate", required = false) String startDateStr,
                                                             @RequestParam(name = "endDate", required = false) String endDateStr,
                                                             @RequestParam(name = "feeSuperType", required = false) String feeSuperType,
                                                             @RequestParam(name = "feeSubType", required = false) String feeSubType,
                                                             @RequestParam(name = "companyValue", required = false) Integer companyValue,
                                                             @RequestParam(name = "companyName", required = false) String companyName,
                                                             @RequestParam(name = "departmentName", required = false) String departmentName,
                                                             @RequestParam(name = "createUserId", required = false) Integer createUserId,
                                                             @RequestParam(name = "payUserId", required = false) Integer payUserId) {
//        if (!StringUtils.isEmpty(departmentName)) {
//            departmentName = departmentName.toLowerCase();
//        }
//        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
//
//        LocalDateTime startDate = LocalDateTime.parse(startDateStr, df);
//        LocalDateTime endDate = LocalDateTime.parse(endDateStr, df);
//
//        List<ManageCostDto> manageCostDtoList = costApiService.getLogisticsCostList(startDate, endDate, feeSuperType, feeSubType, companyValue, companyName, departmentName, createUserId, payUserId);
//        return CostResult.success(manageCostDtoList);

        return CostResult.success();
    }

    @LoginIgnore
    @ApiOperation("根据最后更新时间查询费用单")
    @Override
    @GetMapping({"/getCostList"})
    public CostResult<List<CostDto>> getCostList(@RequestParam String startDate,
                                                 @RequestParam String endDate,
                                                 @RequestParam Integer pageNum,
                                                 @RequestParam Integer pageSize) {
        logger.info("根据最后更新时间查询费用单");
        List<CostDto> costDtoList = this.costApiService.getCostList(startDate, endDate, pageNum, pageSize);
        return CostResult.success(costDtoList);
    }


    @LoginIgnore
    @ApiOperation("获取资产负债表相关费用单")
    @Override
    @GetMapping("/balanceSheetCost")
    public CostResult<List<CostDto>> balanceSheetCostList(@RequestParam(name = "startDate") String startDateStr,
                                                          @RequestParam(name = "endDate") String endDateStr) {
//        logger.warn("获取资产负债表相关费用单");
//        try {
//            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
//            Date startDate = sdf.parse(startDateStr);
//            Date endDate = sdf.parse(endDateStr);
//            List<CostDomain> balanceSheetCostList = costApiService.getBalanceSheetCost(startDate, endDate);
//            return CostResult.success(balanceSheetCostList.stream().map(CostDomain::castToDto).collect(Collectors.toList()));
//
//        } catch (ParseException e) {
//            e.printStackTrace();
//            return CostResult.error();
//        }
        return CostResult.success();
    }


    @LoginIgnore
    @Override
    @ApiOperation("查询原来传输到数据中心时为待支付状态 变成 已支付状态后的费用单")
    @GetMapping("/noPayCost")
    public CostResult<List<CostDto>> getNoPayCost(@RequestParam(name = "costNoList") List<String> costNoList) {
        List<CostDomain> costDomainList = costApiService.getNoPayCost(costNoList);
        return CostResult.success(costDomainList.stream().map(CostDomain::castToDto).collect(Collectors.toList()));
    }


    @LoginIgnore
    @Override
    @ApiOperation("吴通新增 根据费用单号获取费用单大类")
    @GetMapping("/type/{costNo}")
    public CostResult<String> getTypeName(@PathVariable("costNo") String costNo) {
        // 获取费用单详细信息
        CostDomain costDomain = costApiService.getCostDetails(costNo);
        return CostResult.success(costDomain.getTypeName());
    }
}
