package com.blt.other.module.cost.service.impl.cost;

import com.bailuntec.api.bailuntec.cw.CwApi;
import com.bailuntec.api.bailuntec.cw.request.ApplyMoneyDetail;
import com.bailuntec.api.bailuntec.cw.request.PostApplyReq;
import com.bailuntec.api.bailuntec.cw.response.CwResult;
import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.JsonUtilByJackson;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.exception.RpcException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.vo.TofinanceVo;
import com.blt.other.module.database.model.CostCashiercallbackDomain;
import com.blt.other.module.database.model.CostTofinanceDomain;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 11:35 上午
 */
@Slf4j
@Service
public class Lend2PayCostServiceImpl extends AbstractCostService implements CostService {
    @Autowired
    CwApi cwApi;

    @Override
    public void toFinancial(CostDomain cost) {
        if (cost.getLendBalance().compareTo(BigDecimal.ZERO) <= 0) {
            //  付款成功，更改借还单信息，否则返回失败
            String sonNo = cost.getCostNo().toUpperCase();


            cost.setCostStatus(CostDomain.STATUS_PAYED);
            cost.setPayTime(new Date());
            BigDecimal toRmbRate = CurUtils.getCur(cost.getDic(), "CNY");
            cost.setToRmbRate(toRmbRate);
            cost.setAmountRmb(cost.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
            cost.setAuditTime(new Date());
            costDao.updateById(cost);

            //借还单
            if (!sonNo.contains("S")) {
                //关联借支单
                CostDomain supCostDomain = this.getCostByCostNo(cost.getSupCostNo());
                // 借还单在出纳完成收付款后，不用直接获取返回的金额（使用费用系统中记录的提交金额，出纳系统结算的实时汇率和费用系统不一定一致）
                supCostDomain.setHadPay(supCostDomain.getHadPay().add(cost.getAmount()));
                if (supCostDomain.getHadPay().compareTo(supCostDomain.getAmount()) == 0) {
                    //结清
                    supCostDomain.setLendStatus(4);
                } else if (supCostDomain.getHadPay().compareTo(supCostDomain.getAmount()) < 0) {
                    //部分结清
                    supCostDomain.setLendStatus(2);
                } else if (supCostDomain.getHadPay().compareTo(supCostDomain.getAmount()) > 0) {
                    //todo 邮件通知
                    log.error("金额异常 联系管理员,costNo:{}", supCostDomain.getCostNo());
                }
                costDao.updateById(supCostDomain);
            }
            return;
        }

        PostApplyReq req = super.buildPostApplyReq(cost);
        // 审核回调地址(ApplyCallbackUrl)不可为空；
        req.setApplyCallbackUrl(costUrlProperties.costApplyCallbackUrlPost);
        // 出纳回调地址(CashierCallbackUrl)不可为空；
        req.setCashierCallbackUrl(costUrlProperties.costCashierCallbackUrlPost);
        req.setApplyType("" + 1);

        List<ApplyMoneyDetail> applyMoneyDetailList = new ArrayList<>();
        ApplyMoneyDetail applyMoneyDetail = new ApplyMoneyDetail();
        applyMoneyDetail.setName("借支单付款");
        applyMoneyDetail.setMoney(cost.getAmount());
        //todo
        applyMoneyDetail.setMoneyRmb(cost.getAmount());
        applyMoneyDetail.setRemark("");

        applyMoneyDetailList.add(applyMoneyDetail);
        // 出纳申请金额明细(MoneyDetail)不可为空；
        req.setMoneyDetail(applyMoneyDetailList);


        CwResult<String> cwResult = cwApi.postApply(req);
        if (!cwResult.getSuccess()) {
            throw new RpcException(cwResult.getMessage());
        }
        TofinanceVo tofinanceVo = JsonUtilByJackson.readValue(cwResult.getData().replaceAll("/^['|\"](.*)['|\"]$/", ""), TofinanceVo.class);

        //保存财务系统调用信息
        CostTofinanceDomain costTofinanceDomain = new CostTofinanceDomain();
        BeanUtils.copyProperties(tofinanceVo, costTofinanceDomain);
        costTofinanceDomain.setCostNo(cost.getCostNo().toUpperCase());
        costTofinanceDomain.setCode(costTofinanceDomain.getCode().toUpperCase());
        costTofinanceService.saveCostToFinanceMsg(costTofinanceDomain);
    }

    @Override
    public void reject(String costNo) {

        super.reject(costNo);
        //释放已申请的金额
        CostDomain costDomain = costDao.selectByCostNo(costNo);
        CostDomain supCost = costDao.selectByCostNo(costDomain.getSupCostNo());

        supCost.setRepaymentAppliedAmount(supCost.getRepaymentAppliedAmount().subtract(costDomain.getAmount()));
        costDao.updateById(supCost);
    }

    @Override
    void cashierCallbackPass(CostCashiercallbackDomain costCashiercallbackDomain) {
        //  付款成功，更改借还单信息，否则返回失败
        CostDomain costDomain = this.getCostByCostNo(costCashiercallbackDomain.getCostNo());
        String sonNo = costDomain.getCostNo().toUpperCase();


        costDomain.setCostStatus(CostDomain.STATUS_PAYED);
        costDomain.setPayUserId(costCashiercallbackDomain.getPayuserid());
        costDomain.setPayTime(new Date());
        BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY");

        costDomain.setToRmbRate(toRmbRate);
        costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        costDomain.setAuditTime(new Date());
        costDao.updateById(costDomain);


        //借还单
        if (!sonNo.contains("S")) {
            //关联借支单
            CostDomain supCostDomain = this.getCostByCostNo(costDomain.getSupCostNo());
            // 借还单在出纳完成收付款后，不用直接获取返回的金额（使用费用系统中记录的提交金额，出纳系统结算的实时汇率和费用系统不一定一致）
            supCostDomain.setHadPay(supCostDomain.getHadPay().add(costDomain.getAmount()));
            if (supCostDomain.getHadPay().compareTo(supCostDomain.getAmount()) == 0) {
                //结清
                supCostDomain.setLendStatus(4);
            } else if (supCostDomain.getHadPay().compareTo(supCostDomain.getAmount()) < 0) {
                //部分结清
                supCostDomain.setLendStatus(2);
            } else if (supCostDomain.getHadPay().compareTo(supCostDomain.getAmount()) > 0) {
                //todo 邮件通知
                log.error("金额异常 联系管理员,costNo:{}", supCostDomain.getCostNo());
            }
            costDao.updateById(supCostDomain);
        }

        costLogService.save(costDomain.getCostNo(), costDomain.getPayUserId(), "出纳收/付款成功：" + costCashiercallbackDomain.getPaynote());

    }


}
