package com.blt.other.module.cost.service.impl.cost;

import com.bailuntec.api.bailuntec.cw.CwApi;
import com.bailuntec.api.bailuntec.cw.request.PostApplyReq;
import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostListPrintDto;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.MoneyUtil;
import com.blt.other.module.auth.dao.CostReviewerMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.service.UserService;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostDetailDao;
import com.blt.other.module.cost.dao.CostTypeKindDao;
import com.blt.other.module.cost.dto.CostApiDto;
import com.blt.other.module.cost.dto.CostPageResult;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostLogService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.service.CostTofinanceService;
import com.blt.other.module.cost.service.ICostTemplateService;
import com.blt.other.module.cost.service.impl.costcheck.DepartmentCheckState;
import com.blt.other.module.database.model.CostCompanyDomain;
import com.blt.other.module.database.model.CostTypeKindDomain;
import com.blt.other.module.database.model.UserDomain;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 11:35 上午
 */
@Slf4j
public abstract class AbstractCostService implements CostService {


    @Autowired
    CwApi cwApi;


    @Value("${url.my.costApplyCallbackUrlPost}")
    String costApplyCallbackUrlPost;
    @Value("${url.my.costCashierCallbackUrlPost}")
    String costCashierCallbackUrlPost;
    @Value("${url.my.lendCostApplyCallBackUrlPost}")
    String lendCostApplyCallBackUrlPost;
    @Value("${url.my.lendCostCashierCallbackUrlPost}")
    String lendCostCashierCallbackUrlPost;


    @Autowired
    CostTofinanceService costTofinanceService;
    @Autowired
    CostDao costDao;
    @Autowired
    UserService userService;
    @Autowired
    ICostTemplateService costTemplateService;
    @Autowired
    CostCompanyDao costCompanyDao;
    @Autowired
    CostTypeKindDao costTypeKindDao;
    @Autowired
    CostDetailDao costDetailDao;
    @Autowired
    CostLogService costLogService;
    @Resource
    CostSubscribe costSubscribe;
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    OaUserMapper oaUserMapper;

    @Override
    public Integer saveNewCost(CostDomain costDomain) {
        throw new BizRuntimeException("deprecated method");
    }

    @Override
    public CostPageResult getAllCost(Integer pageNum,
                                     Integer pageSize,
                                     Integer userId,
                                     String projectTypes) {
        PageHelper.startPage(pageNum, pageSize);
        List<String> projectTypeList = new ArrayList<>();
        if (!StringUtils.isEmpty(projectTypes)) {
            projectTypeList = Lists.newArrayList(projectTypes.split(",")).stream().filter(str -> !StringUtils.isEmpty(str)).collect(Collectors.toList());
        }
        List<CostDomain> costDomains = costDao.selectAll(userId, projectTypeList);

        CostPageResult result = new CostPageResult();
        result.setCosts(costDomains.stream().map(CostDomain::castToDto).collect(Collectors.toList()));
        result.setPageInfo(new PageInfo<>(costDomains));
        return result;
    }

    @Override
    public CostDomain getCostByCostNo(String costNo) {
        CostDomain costDomain = costDao.selectByCostNo(costNo);
        costDomain.setCostTemplate(costTemplateService.queryDetail(costDomain.getCostTemplateId()));
        return costDomain;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CostApiDto.UpdateCostResp updateCost(CostDomain costDomain) {
        CostApiDto.UpdateCostResp resp = new CostApiDto.UpdateCostResp();

        setCostDomain(costDomain);
        Integer update = costDao.update(costDomain);


        resp.setMsg("success");
        resp.setResult(costDao.selectByCostNo(costDomain.getCostNo()));
        resp.setUpdate(update);
        return resp;

    }

    private void setCostDomain(CostDomain costDomain) {
        if (null != costDomain.getCompanyNo()) {
            costDomain.setCompanyName(costCompanyDao.selectByNo(costDomain.getCompanyNo()).getCompanyName());
        }
        if (null != costDomain.getKindNo() && !"".equals(costDomain.getKindNo())) {
            CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(costDomain.getKindNo());
            if (null != costTypeKindDomain) {
                costDomain.setKindName(costTypeKindDomain.getKindName());
                costDomain.setTypeName(costTypeKindDomain.getTypeName());
                costDomain.setTypeNo(costTypeKindDomain.getTypeNo());
            }
        }
    }


    @Override
    public List<CostDto> getByCostPlanNo(String costPlanNo) {
        return costDao.selectByCostPlanNo(costPlanNo)
                .stream()
                .map(CostDomain::castToDto)
                .collect(Collectors.toList());
    }

    @Override
    public void resetCost(String costNo) {
        List<CostDetailDomain> costDetailDomains = costDetailDao.selectListByCostNo(costNo);
        BigDecimal amount = new BigDecimal(0);
        if (null != costDetailDomains && costDetailDomains.size() >= 1) {
            for (CostDetailDomain domain : costDetailDomains) {
                amount = amount.add(domain.getAmount());
            }
            CostDomain costDomain = new CostDomain();
            costDomain.setCostNo(costNo);
            costDomain.setAmount(amount);
            costDomain.setKindName(costDetailDomains.get(0).getKindName() + " 等 " + costDetailDomains.size() + " 项");
            costDao.update(costDomain);
        }
    }

    @Override
    public Integer setStatus(String costNo, int i) {
        CostDomain costDomain = new CostDomain();
        costDomain.setCostNo(costNo);
        costDomain.setCostStatus(i);
        return costDao.update(costDomain);
    }

    @Override
    public Integer updateById(CostDomain costDomain) {
        return costDao.updateById(costDomain);
    }

    @Override
    public void updateCashierAnnex(String costNo, String filePath, String downloadUrl) {
        costDao.updateCashierAnnex(costNo, filePath, downloadUrl);
    }

    @Override
    public List<CostListPrintDto> printList(List<String> printNos) {
        return printNos.stream().map(this::printDto).collect(Collectors.toList());
    }

    @Transactional
    @Override
    public IPage<CostDto> checkCostList(Integer userid, Integer pageNum, Integer pageSize, Integer type) {
        IPage<CostDomain> page = new Page<>(pageNum, pageSize);
        LambdaQueryWrapper<CostDomain> wrapper = new LambdaQueryWrapper<>();
        UserDomain userDomain = userService.findByUserid(userid);
        //财务或者管理员
        if (userDomain.getIsadmin() != 0 || userDomain.getIsfinansys() != 0) {
            wrapper.in(CostDomain::getCompanyValue, Lists.newArrayList(userDomain.getAuthority().split(",")));
        } else {
            wrapper.eq(CostDomain::getCreateUserid, userid);
        }
        //财务 最终审核
        if (type == 1) {
            wrapper.in(CostDomain::getCostStatus, CostDomain.STATUS_FINAL_CHECK, CostDomain.STATUS_DEPARTMENT_CHECK);
        }
        //部门审核
        else if (type == 2) {
            wrapper.in(CostDomain::getCostStatus, CostDomain.STATUS_DEPARTMENT_CHECK);
        } else {
            log.warn("invalid type");
        }
        return costDao.selectPage(page, wrapper).convert(CostDomain::castToDto);
    }


    private CostListPrintDto printDto(String costNo) {
        CostListPrintDto print = new CostListPrintDto();
        CostDto cost = this.getCostByCostNo(costNo).castToDto();
        UserDomain user = userService.findByUserid(cost.getCreateUserid());
        if (user == null) {
            print.setDepartment("");
            print.setCreateUsername(cost.getCreateUsername() + "【注销】");
        } else {
            print.setDepartment(user.getDepartmentname1());
            print.setCreateUsername(cost.getCreateUsername());
        }
        print.setId(cost.getId());
        print.setCompanyName(cost.getCompanyName());
        print.setCostNo(costNo);
        print.setCreateTime(cost.getCreateTime());
        print.setBankCompany(cost.getBankCompany());
        print.setBankCardUser(cost.getBankCardUser());
        print.setBankCard(cost.getBankCard());
        print.setCostReason(cost.getCostReason());
        print.setDic(cost.getDicDto());
        print.setAmount(cost.getAmountDto());
        print.setTxtAmount(MoneyUtil.getCnNum(cost.getAmount()));
        if (1 == cost.getCostForm()) {
            // 付款单
            print.setCostFormStr("付");
            print.setBankCompanyStr("收款单位");
            print.setBankCardUserStr("收款户名");
            print.setFeeTypeStr("付款方式");
            print.setBankCardStr("收款账户");
            print.setCostReasonStr("付款理由");
            print.setCostReason(cost.getTypeName() + "/" + cost.getKindName() + ";  " + cost.getCostRemark());
            // 差额单的付款理由需详细说明
            if (null != cost.getIsLend() && 2 == cost.getIsLend()) {
                print.setCostReason("【差额单（关联借支单：" + cost.getSupCostNo() + "）】 " + cost.getTypeName() + "  " + cost.getCostRemark());
            }
            print.setCostAmountStr("付款金额");
        }
        if (2 == cost.getCostForm()) {
            // 收款单
            print.setCostFormStr("收");
            print.setBankCompanyStr("付款单位");
            print.setBankCardUserStr("付款户名");
            print.setFeeTypeStr("收款方式");
            print.setBankCardStr("付款账户");
            print.setCostReasonStr("收款理由");
            print.setCostAmountStr("收款金额");
        }

        if (3 == cost.getCostForm() && 1 == cost.getIsLend()) {
            // 借支单
            print.setCostFormStr("借支");
            print.setBankCompanyStr("收款单位");
            print.setBankCardUserStr("收款户名");
            print.setFeeTypeStr("付款方式");
            print.setBankCardStr("收款账户");
            print.setCostReasonStr("付款理由");
            print.setCostAmountStr("付款金额");
        }

        if (3 == cost.getCostForm() && 2 == cost.getIsLend()) {
            // 借还单
            print.setCostFormStr("借还");
            print.setBankCompanyStr("付款单位");
            print.setBankCardUserStr("付款户名");
            print.setFeeTypeStr("收款方式");
            print.setBankCardStr("付款账户");
            print.setCostReasonStr("收款理由");
            print.setCostAmountStr("收款金额");
            print.setDic(cost.getPayDicDto());
            print.setAmount(cost.getPayPlanAmountDto());
            print.setTxtAmount(MoneyUtil.getCnNum(cost.getPayPlanAmount()));
        }
        return print;
    }

    PostApplyReq buildPostApplyReq(CostDomain cost) {
        CostCompanyDomain companyByCompanyNo = costCompanyDao.selectByNo(cost.getCompanyNo());


        PostApplyReq req = new PostApplyReq();
        // 公司主体(CompanyMainName)不可为空；
        req.setCompanyMainName(cost.getCompanyName());
        req.setTitle(cost.getCostNo());

//        if (cost.getCostNo().startsWith("S")) {
//            log.info("补差额的付款单：" + cost.getCostNo());
//            applyMoneyDetail.setName("借支单补差额");
//            // 审核回调地址(ApplyCallbackUrl)不可为空；
//            req.setApplyCallbackUrl(lendCostApplyCallBackUrlPost);
//            // 出纳回调地址(CashierCallbackUrl)不可为空；
//            req.setCashierCallbackUrl(lendCostCashierCallbackUrlPost);
//
//        } else {
//            // 审核回调地址(ApplyCallbackUrl)不可为空；
//            req.setApplyCallbackUrl(costApplyCallbackUrlPost);
//            // 出纳回调地址(CashierCallbackUrl)不可为空；
//            req.setApplyCallbackUrl(costCashierCallbackUrlPost);
//        }
        // 币种编号(UnitCode)不可为空；
        req.setUnitCode(cost.getDic());
        // 币种名称(UnitName)不可为空；
        req.setUnitName(cost.getDic());
        // 交易对象改为付款/收款单位

        // 交易对象(TradeObjectID/TradeObjectName)不可为空；
        req.setTradeObjectID(companyByCompanyNo.getValue() + "");
        req.setTradeObjectName(cost.getBankCompany() + "");
        req.setBankCardto(cost.getBankCard());
        // 交易对象账户(BankNameto/BankCardto/BankCardUserto)资料不完整；
        req.setBankCardUserto(cost.getBankCardUser());
        // newOtherPurchase申请来源(SourceCode/SourceTypeCode)不可为空；
        req.setSourceCode("newCost");
        req.setSourceTypeCode("newCostType");
        // 账期 0 PayDay
        req.setPayDay(0);
        // 预计付款时间 ExpectPayTime
        req.setExpectPayTime(new Date());


//        // 申请类型(ApplyType)不存在；申请类型:1#付款;2#收款;3#无需付款;
//        if (1 == cost.getCostForm()) {
//            req.setApplyType("" + 1);
//            applyMoneyDetail.setName("费用单付款");
//        } else if (2 == cost.getCostForm()) {
//            req.setApplyType("" + 2);
//            applyMoneyDetail.setName("费用单收款");
//        } else if (3 == cost.getCostForm() && 1 == cost.getIsLend()) {
//            req.setApplyType("" + 1);
//            applyMoneyDetail.setName("借支单付款");
//        }
        // 申请人(UserAcctID/UserAcctName)不存在；
        req.setUserAcctID("" + cost.getCreateUserid());
        req.setUserAcctName("" + cost.getCreateUsername());


        // 设置 detailKey
        String detailKey = cost.getDetailKey();
        if (null == detailKey || !detailKey.contains("F")) {
            detailKey = cost.getCostNo();
        }
        // 回调必要的key参数（DetailKey）不能为空；
        req.setDetailKey(detailKey);
        req.setTypeName(cost.getTypeName());
        return req;
    }
}
