package com.blt.other.module.cost.service;

import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.CostListPrintDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.blt.other.module.cost.dto.CostApiDto;
import com.blt.other.module.cost.dto.CostPageResult;
import com.blt.other.module.cost.model.CostDomain;

import java.util.List;

public interface CostService {

    /**
     * 保存新费用单
     *
     * @param costDomain cost
     * @return res
     */
//    @Deprecated
    Integer saveNewCost(CostDomain costDomain);

    /**
     * 获取所有费用单
     *
     * @return allCost
     */
    CostPageResult getAllCost(Integer pageNum, Integer pageSize, Integer userId, String projectTypes);

    /**
     * 根据 costNo 获取 cost
     *
     * @param costNo costNo
     * @return cost
     */
    CostDomain getCostByCostNo(String costNo);

    /**
     * 修改费用单信息
     *
     * @param costDomain costDomain
     * @return res
     */
    CostApiDto.UpdateCostResp updateCost(CostDomain costDomain);


    /**
     * 根据费计划查询费用单
     *
     * @param costPlanNo 计划单号
     * @return 费用单
     */
    List<CostDto> getByCostPlanNo(String costPlanNo);

    /**
     * 刷新费用单
     *
     * @param costNo 费用单号
     */
    void resetCost(String costNo);

    /**
     * 更新费用单状态
     *
     * @param costNo 费用单号
     * @param i      status
     * @return res
     */
    Integer setStatus(String costNo, int i);

    /**
     * 更新费用单
     *
     * @param costDomain entity
     * @return res
     */
    Integer updateById(CostDomain costDomain);


    /**
     * 更新附件
     *
     * @param costNo      费用单编号
     * @param filePath    文件
     * @param downloadUrl 附件
     */
    void updateCashierAnnex(String costNo, String filePath, String downloadUrl);

    /**
     * <p>
     * 获取费用单号对应的前端需要的打印参数
     * </p>
     *
     * @param printNos 费用单号列表
     * @return res
     */
    List<CostListPrintDto> printList(List<String> printNos);


    /**
     * 审核费用单列表
     *
     * @param pageSize page
     * @param pageNum  page
     * @param userid   当前用户id
     * @param type     1-财务+最终审核 2-部门审核
     * @return 费用单列表
     */
    IPage<CostDto> checkCostList(Integer userid, Integer pageNum, Integer pageSize, Integer type);

    /**
     * <p>
     * 审核成功通知财务系统付款
     * </p>
     *
     * @param costDomain cost
     */
    void toFinancial(CostDomain costDomain);
}
