package com.blt.other.module.cost.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.module.cost.model.CostDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;


@Mapper
public interface CostPlanDao extends BaseMapper<CostPlanDomain> {


    CostPlanDomain selectByNo(String planNo);

    /**
     * <p>
     * 根据计划单号删除计划单
     * </p>
     *
     * @param costPlanNo 计划单号
     * @return res
     */
    Integer deleteByNo(String costPlanNo);

    List<CostPlanDomain> selectAll(@Param("userId") Integer userId);

    Page<CostPlanDomain> queryPageFor4k(@Param("page") Page<Object> page);
}
