package com.blt.other.module.purchasing.service.impl;

import com.blt.other.database.model.BuyPlanDomain;
import com.blt.other.module.purchasing.dao.BuyPlanSearchDao;
import com.blt.other.module.purchasing.dto.BuyPlanDto;
import com.blt.other.module.purchasing.service.BuyPlanSearchService;
import com.blt.other.module.purchasing.service.BuyPlanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class BuyPlanSearchServiceImpl implements BuyPlanSearchService {

    @Autowired
    private BuyPlanSearchDao buyPlanSearchDao;
    @Autowired
    private BuyPlanService buyPlanService;

    @Override
    public List<BuyPlanDto> searchByKey(String key) {
        List<BuyPlanDomain> buyPlanDomains = buyPlanSearchDao.selectByKey(key);
        List<BuyPlanDto> dtoList = buyPlanService.getDtoList(buyPlanDomains);
        return dtoList;
    }
}
