package com.blt.other.common.rabbitmq.declare;

import com.blt.other.common.rabbitmq.model.MqExchange;
import com.blt.other.common.rabbitmq.type.ExchangeTypeEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-04-28
 * @Modified by:
 */
@Component
@Slf4j
public class AmExchangeDeclare extends AbstractDeclare {

    /**
     * 向rabbitMQ服务器注册指定的交换机以及交换机的类型
     *
     * @param mqExchage
     * @return
     */
    public Exchange declareExchange(MqExchange mqExchage) {
        log.info("declare exchange is :" + mqExchage.toString());

        Exchange exchange = null;

        exchange = this.initExchange(mqExchage);
        this.rabbitAdmin.declareExchange(exchange);

        log.info("declare exchange success");
        return exchange;
    }


    /**
     * 从RabbitMQ服务端上删除指定的交换机
     *
     * @param exchangeName
     * @return
     */
    public boolean deleteExchange(String exchangeName) {
        log.info("delete exchange is : " + exchangeName);

        if (StringUtils.isEmpty(exchangeName)) {
            throw new AmqpException("the parameter exchangeName couldn't not be null");
        }

        return this.rabbitAdmin.deleteExchange(exchangeName);
    }

    /**
     * 根据不同类型初始化不同类型的交换机
     *
     * @param mqExchage
     * @return
     */
    private Exchange initExchange(MqExchange mqExchage) {
        ExchangeTypeEnum exchangeTypeEnum = mqExchage.getType();
        switch (exchangeTypeEnum) {
            case DIRECT:
                return new DirectExchange(mqExchage.getName(), mqExchage.isDurable(), mqExchage.isAutoDelete(), mqExchage.getArguments());
            case TOPIC:
                return new TopicExchange(mqExchage.getName(), mqExchage.isDurable(), mqExchage.isAutoDelete(), mqExchage.getArguments());
            case FANOUT:
                return new FanoutExchange(mqExchage.getName(), mqExchage.isDurable(), mqExchage.isAutoDelete(), mqExchage.getArguments());
            case HEADERS:
                return new HeadersExchange(mqExchage.getName(), mqExchage.isDurable(), mqExchage.isAutoDelete(), mqExchage.getArguments());
            default:
                return null;
        }
    }
}
