package com.blt.other.module.cost.service.impl.costplan;

import com.bailuntec.common.ListUtil;
import com.bailuntec.common.StringUtils;
import com.bailuntec.cost.api.dto.CostPlanDto;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.database.model.*;
import com.blt.other.module.auth.dao.UserDao;
import com.blt.other.module.cost.dao.*;
import com.blt.other.module.cost.dto.request.GetAllCostPlanReq;
import com.blt.other.module.cost.dto.response.GetAllCostPlanResp;
import com.blt.other.module.cost.dto.response.GetCostPlanResp;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplateBaseCol;
import com.blt.other.module.cost.service.*;
import com.blt.other.module.cost.utils.CostUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/16 1:28 下午
 */
public abstract class AbstractCostPlanService implements CostPlanService {


    @Autowired
    UserCostFinansysService userCostFinansysService;
    @Autowired
    CostPlanDao costPlanDao;
    @Autowired
    CostCompanyDao costCompanyDao;
    @Autowired
    UserDao userDao;
    @Autowired
    CostPlanTempDao costPlanTempDao;
    @Autowired
    CostDao costDao;
    @Autowired
    CostTypeDao costTypeDao;
    @Autowired
    CostPlanTempService costPlanTempService;
    @Autowired
    ICostTemplateService costTemplateService;
    @Autowired
    CostLogService costLogService;
    @Autowired
    CostDetailDao costDetailDao;
    @Resource
    CostService costService;


    void check(CostPlanDomain planDomain) {

        if (planDomain.getPlanAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BizRuntimeException("金额必须大于0元");
        }
    }

    /**
     * <p>
     * 保存填写的财务信息到历史记录
     * </p>>
     */
    public void doSaveFinanceRecord(CostPlanDomain planDomain) {
        UserCostFinansysDomain financeRecordByCostDomain = userCostFinansysService.createFinanceRecordByCostPlanDomain(planDomain);
        userCostFinansysService.saveFinancesRecord(financeRecordByCostDomain);
    }

    @Resource
    CostTemplateBaseColMapper costTemplateBaseColMapper;

    /**
     * <p>
     * 补全费用计划参数
     * </p>
     *
     * @param costPlanDomain 费用计划source
     */
    protected void completedCostPlan(CostPlanDomain costPlanDomain) {

        CostCompanyDomain companyDomain = costCompanyDao.selectByNo(costPlanDomain.getCompanyNo());
        if (companyDomain != null) {
            costPlanDomain.setCompanyName(companyDomain.getCompanyName());
            costPlanDomain.setCompanyValue(companyDomain.getValue());
        }

        UserDomain user = userDao.select(costPlanDomain.getCreateUsercode());
        if (user != null) {
            costPlanDomain.setCreateUserid(user.getUserid());
            costPlanDomain.setCreateUsername(user.getUsername());
            costPlanDomain.setCreateTime(new Date());
            //借还单 借还币种 -> 借支币种汇率
            costPlanDomain.setPayCur(costPlanDomain.getCur());
        }

        if (ListUtil.isNotEmpty(costPlanDomain.getAttach())) {
            costPlanDomain.getAttach().forEach(costAttach -> {
                CostTemplateBaseCol costTemplateBaseCol = costTemplateBaseColMapper.selectById(costAttach.getCostTemplateBaseColId());
                BeanUtils.copyProperties(costTemplateBaseCol, costAttach, "id");
            });
        }

        if (StringUtils.isNotEmpty(costPlanDomain.getTypeNo())) {
            CostTypeDomain costTypeDomain = costTypeDao.selectByNo(costPlanDomain.getTypeNo());
            costPlanDomain.setAccountingSubjectId(costTypeDomain.getAccountingSubjectId());
        }

    }

    @Override
    public String createNo() {

        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddhhmmss");
        String no = "CP" + sdf.format(new Date()) + random.nextInt(9);
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(no);
        while (null != costPlanDomain && null != costPlanDomain.getCostPlanNo()) {
            no = "CP" + sdf.format(new Date()) + random.nextInt(9);
            costPlanDomain = costPlanDao.selectByNo(no);
        }
        return no;
    }

    @Override
    public void deleted(String costPlanNo) {
        if (costPlanNo.startsWith("S")) {
            //费用计划
            CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
            //费用计划关联借支单
            CostDomain costDomain = costService.getCostByCostNo(costPlanDomain.getSupCostNo());
            costDomain.setCompensate(costDomain.getCompensate().subtract(costPlanDomain.getPlanAmount()));
            costDomain.setLastModifyDate(LocalDateTime.now());
            costDao.updateById(costDomain);
        }
        costPlanDao.deleteByNo(costPlanNo);
    }

    @Override
    public GetAllCostPlanResp getAllCostList(GetAllCostPlanReq req) {
        if (req.getAuthType() != null && req.getAuthType() != 0) {
            req.setUserId(null);
        }
        PageHelper.startPage(req.getPageNum(), req.getPageSize());

        List<CostPlanDomain> allCostList = costPlanDao.selectAll(req.getUserId());
        PageInfo<CostPlanDomain> pageInfo = new PageInfo<>(allCostList);
        List<CostPlanDto> costPlanDtos = allCostList.stream().map(CostPlanDomain::castToDto).collect(Collectors.toList());

        return new GetAllCostPlanResp(true, costPlanDtos, pageInfo);
    }

    @Override
    public GetCostPlanResp getByPlanNo(String planNo) {
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(planNo);

        costPlanDomain.setCostTemplate(costTemplateService.queryDetail(costPlanDomain.getCostTemplateId()));
        String filePath = costPlanDomain.getFilePath();
        String fileName = null;
        if (null != filePath && filePath.length() >= 1) {
            String[] split = filePath.split("&");
            if (split.length >= 1) {
                fileName = split[split.length - 1];
            }
        }
        GetCostPlanResp result = new GetCostPlanResp();
        result.setCostPlan(costPlanDomain);
        result.setFileName(fileName);
        return result;
    }


    protected CostDomain planToCost(String costPlanNo) {
        CostDomain costDomain = new CostDomain();
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
        BeanUtils.copyProperties(costPlanDomain, costDomain);

        costDomain.setCompanyValue(costCompanyDao.selectByNo(costPlanDomain.getCompanyNo()).getValue());
        costDomain.setAttach(costPlanDomain.getAttach());
        return costDomain;
    }

    protected CostDetailDomain tempToDetail(CostPlanTempDomain costPlanTempDomain,
                                            CostPlanDomain costPlanDomain,
                                            Integer index) {

        CostDetailDomain costDetailDomain = new CostDetailDomain();
        BeanUtils.copyProperties(costPlanDomain, costDetailDomain);
        BeanUtils.copyProperties(costPlanTempDomain, costDetailDomain);
        costDetailDomain.setDetailNo(costPlanDomain.getCostPlanNo() + "-" + index);

        return costDetailDomain;
    }

    /**
     * 生成 costNo
     *
     * @return costNo
     */
    protected String getCostNo() {
        String costNo = CostUtils.getIdNum();
        CostDomain costByNo = costService.getCostByCostNo(costNo);
        while (null != costByNo && null != costByNo.getId()) {
            costNo = CostUtils.getIdNum();
        }
        return costNo;
    }

}
