package com.blt.other.module.cost.service.impl;

import com.bailuntec.common.SpringContextUtil;
import com.bailuntec.cost.api.dto.CostDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dto.request.AppCheckCostListReq;
import com.blt.other.module.cost.dto.request.AppCostListReq;
import com.blt.other.module.cost.dto.request.AppCostPassReq;
import com.blt.other.module.cost.dto.request.AppCostRejectReq;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.AppCostService;
import com.blt.other.module.cost.service.CostDetailService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.service.impl.costcheck.*;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/14 1:22 下午
 */
@Service
public class AppCostServiceImpl implements AppCostService {

    @Resource
    CostDao costDao;
    @Resource
    CostDetailService costDetailService;

    @Resource
    CostService costService;

    @Override
    public Page<CostDto> appCheckCostList(AppCheckCostListReq req) {
        IPage<CostDomain> costDomainIPage = new Page<>(req.getPageNum(), req.getPageSize());
        costDetailService.setDetail(costDomainIPage.getRecords());

        Page<CostDomain> result = costDao.appCheckCostList(costDomainIPage, req);
        costDetailService.setDetail(result.getRecords());
        return (Page<CostDto>) result.convert(CostDomain::castToDto);
    }

    @Override
    public void appCostPass(AppCostPassReq req) {
        CostContext costContext = this.getCostState(req.getCostNo(), req.getOaUserId());
        costContext.handle();
    }

    @Override
    public void appCostReject(AppCostRejectReq req) {
        CostContext costContext = this.getCostState(req.getCostNo(), req.getOaUserId());
        costContext.refuse(req.getRejectReason());
    }

    @Override
    public Page<CostDto> appCostList(AppCostListReq req) {
        IPage<CostDomain> costDomainIPage = new Page<>(req.getPageNum(), req.getPageSize());
        Page<CostDomain> result = costDao.appCostList(costDomainIPage, req);
        costDetailService.setDetail(result.getRecords());
        return (Page<CostDto>) result.convert(CostDomain::castToDto);
    }

    private CostContext getCostState(String costNo, Integer oaUserId) {
        CostDomain costDomain = costService.getCostByCostNo(costNo);
        CostState costState;
        CostContext costContext;
        switch (costDomain.getCostStatus()) {
            case CostDomain.STATUS_DEPARTMENT_CHECK:
                costState = SpringContextUtil.getBean(DepartmentCheckState.class);
                costContext = new CostContext(costNo, oaUserId);
                costContext.setCostState(costState);
                return costContext;
            case CostDomain.STATUS_FINANCIAL_CHECK:
                costState = SpringContextUtil.getBean(FinancialCheckState.class);
                costContext = new CostContext(costNo, oaUserId);
                costContext.setCostState(costState);
                return costContext;
            case CostDomain.STATUS_HR_CHECK:
                costState = SpringContextUtil.getBean(HrCheckState.class);
                costContext = new CostContext(costNo, oaUserId);
                costContext.setCostState(costState);
                return costContext;
            case CostDomain.STATUS_FINAL_CHECK:
                costState = SpringContextUtil.getBean(FinalCheckState.class);
                costContext = new CostContext(costNo, oaUserId);
                costContext.setCostState(costState);
                return costContext;
            default:
                throw new BizRuntimeException("invalid cost status");
        }
    }
}
