package com.blt.other.module.auth.service.impl;

import com.bailuntec.common.ListUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.module.auth.dao.CostReviewerMapper;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.CostReviewer;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.auth.service.IOaCompanyService;
import com.blt.other.module.auth.service.IOaDepartmentService;
import com.google.common.collect.Lists;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/13 5:33 下午
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
@ActiveProfiles("test")
public class OaDepartmentServiceImplTest {

    @Resource
    OaDepartmentMapper oaDepartmentMapper;
    @Resource
    OaUserMapper oaUserMapper;
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    IOaDepartmentService oaDepartmentService;
    @Resource
    IOaCompanyService oaCompanyService;

    @Test
    public void initDepartment() {
        oaDepartmentMapper.selectList(new LambdaQueryWrapper<>())
                .forEach(oaDepartment -> {
                    OaUser oaUser = oaUserMapper.selectByUserName(oaDepartment.getManageUser1());


                    try {
                        oaDepartmentService.modifyFinancialReviewer(0, oaDepartment.getDepartmentId(), Lists.newArrayList(oaUser.getOaUserId()));
                    } catch (Exception ignore) {

                    }
                    oaDepartment.setCreateUserId(0);
                    oaDepartment.setCreateUserName("sys");
                });

        oaCompanyService.list(new LambdaQueryWrapper<>()).forEach(oaCompany -> {
            if (oaCompany.getName().contains("四千里") ||
                    oaCompany.getName().contains("4k") ||
                    oaCompany.getName().contains("歌戈儿") ||
                    oaCompany.getName().contains("迪致") ||
                    oaCompany.getName().contains("快询")) {

            }
        });

    }

    @Test
    public void setDepartmentReviewer() {

        oaDepartmentMapper.selectList(new LambdaQueryWrapper<>())
                .forEach(oaDepartment -> {
                    try {

                        List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                                .eq(CostReviewer::getType, CostReviewer.departmentReviewer)
                                .eq(CostReviewer::getReferId, oaDepartment.getDepartmentId()));

                        if (ListUtil.isEmpty(costReviewerList)) {
                            String manage = oaDepartment.getManageUser1();
                            OaUser oaUser = oaUserMapper.selectByUserName(manage);

                            CostReviewer costReviewer = CostReviewer.builder()
                                    .reviewerUserId(oaUser.getOaUserId())
                                    .reviewerUserName(oaUser.getUserName())
                                    .referId(oaDepartment.getDepartmentId())
                                    .type(CostReviewer.departmentReviewer)
                                    .build();

                            costReviewerMapper.insert(costReviewer);
                        }

                    } catch (Exception ignore) {

                    }
                });
    }
}
