package com.blt.other.other_cost.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_cost.dto.LogisticsFinansysDto;
import com.blt.other.other_cost.dto.SubLogisticsFinansysDto;
import com.blt.other.other_cost.service.UserCostFinansysService;
import com.blt.other.other_database.model.UserCostFinansysDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("user/cost/finansys")
public class UserCostFinansysController {

    @Autowired
    private UserCostFinansysService userCostFinansysService;

    @PostMapping("/getFinansysRecord")
    public Map<String,Object> getFinansysRecord(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);

        String userid = request.getParameter("userid");
        List<UserCostFinansysDomain> byUsercode = userCostFinansysService.getByUserid(Integer.parseInt(userid));
        Map<String,Object> result = new HashMap<>();
        result.put("success",true);
        result.put("userFinansys",byUsercode);
        return result;
    }

    @PostMapping("/getFinansysRecordByNo")
    public Map<String,Object> getFinansysRecordByNo(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);

        String userCostFinansysNo = request.getParameter("userCostFinansysNo");
        UserCostFinansysDomain userCostFinansys = userCostFinansysService.getByUserCostFinansysNo(userCostFinansysNo);
        Map<String,Object> result = new HashMap<>();
        result.put("success",true);
        result.put("userCostFinansys",userCostFinansys);
        return result;
    }

    @PostMapping("/getAllFinansysRecord")
    public Map<String,Object> getAllFinansysRecord(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        List<UserCostFinansysDomain> list = userCostFinansysService.getAllFinansysRecord();
        result.put("success",true);
        result.put("allFinansys",list);
        return result;
    }

    /**
     * 获取所有一、二级物流供应商财务信息
     * @param response
     * @param request
     * @return
     */
    @GetMapping("/getAllLogisticsFinansys")
    public Map<String,Object> getAllLogisticsFinansys(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        List<LogisticsFinansysDto> list = userCostFinansysService.getAllLogisticsFinansys();
        List<SubLogisticsFinansysDto> subList = userCostFinansysService.getAllSubLogisticsFinansys();
        result.put("success",true);
        result.put("allLogisticsFinansys",list);
        result.put("allSubLogisticsFinansys",subList);
        return result;
    }

}
