package com.blt.other.module.cost.service.impl.costcheck;

import com.bailuntec.common.ListUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.auth.model.CostReviewer;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.model.CostDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:57 下午
 */
@Component
public class UnSubmitState extends CostState {

    @Autowired
    DepartmentCheckState departmentCheckState;

    @Override
    void nextState(CostState costState) {
        super.nextState(costState);

        CostDomain costDomain = costContext.costDomain;
        OaUser costUser = oaUserMapper.selectByOaUserId(costDomain.getCreateUserid());

        List<CostReviewer> costReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                .eq(CostReviewer::getReferId, costUser.getPrimaryDepartmentId())
                .eq(CostReviewer::getType, CostReviewer.departmentReviewer));
        if (ListUtil.isNotEmpty(costReviewerList)) {
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void handle() {

        CostDomain costDomain = costContext.costDomain;
        //校验费用单状态 和 当前处理用户
        if ((costDomain.getCostStatus() != CostDomain.STATUS_UN_SUBMIT && costDomain.getCostStatus() != CostDomain.STATUS_REJECT) ||
                !costDomain.getCreateUserid().equals(costContext.currentUserId)) {
            throw new BizRuntimeException("invalid status");
        }

        //更新费用单
        costDomain.setCostStatus(CostDomain.STATUS_DEPARTMENT_CHECK);
        costDomain.setLastModifyDate(LocalDateTime.now());
        costDao.updateById(costDomain);
        costLogService.save(costDomain.getCostNo(), costContext.currentUserId, "提交费用单");


        nextState(departmentCheckState);
        //发布到总线尝试下个环节的自动审核
        costSubscribe.subscribe(costContext);
    }

    @Override
    public void refuse(String rejectReason) {
        throw new BizRuntimeException("unsupported operate ");
    }
}
