package com.blt.other.module.cost.service.impl;

import com.bailuntec.common.ListUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.module.cost.dao.CostCurrentReviewerMapper;
import com.blt.other.module.cost.model.CostCurrentReviewer;
import com.blt.other.module.cost.service.ICostCurrentReviewerService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 费用单当前审核人 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-12-16
 */
@Service
public class CostCurrentReviewerServiceImpl extends ServiceImpl<CostCurrentReviewerMapper, CostCurrentReviewer> implements ICostCurrentReviewerService {

    @Override
    public Boolean canAudit(Integer oaUserId, String costNo) {
        List<CostCurrentReviewer> costCurrentReviewerList = baseMapper.selectList(new LambdaQueryWrapper<CostCurrentReviewer>()
                .eq(CostCurrentReviewer::getCostNo, costNo));
        return ListUtil.isNotEmpty(costCurrentReviewerList) && costCurrentReviewerList.stream()
                .map(CostCurrentReviewer::getOaUserId).anyMatch(id -> id.equals(oaUserId));
    }
}
