package com.blt.other.module.cost.service.impl.costcheck;

import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.cost.model.CostDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:57 下午
 */
@Component
public class UnSubmitState extends CostState {

    @Autowired
    DepartmentCheckState departmentCheckState;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void handle() {

        CostDomain costDomain = costContext.costDomain;
        //校验费用单状态 和 当前处理用户
        if (costDomain.getCostStatus() != CostDomain.STATUS_UN_SUBMIT ||
                !costDomain.getCreateUserid().equals(costContext.currentUserId)) {
            throw new BizRuntimeException("invalid status");
        }

        //更新费用单
        costDomain.setCostStatus(1);
        costDao.updateById(costDomain);
        costLogService.save(costDomain.getCostNo(), costContext.currentUserId, "提交费用单");

        //清空审核上下文的审核人
        costContext.currentUserId = null;
        //并且流转到下一个状态
        costContext.setCostState(departmentCheckState);
        //尝试审核(由于清空了审核人，这里只会走自动审核)
        costContext.handle();
    }

    @Override
    public void refuse() {

    }
}
