package com.blt.other.module.purchasing.service;

import com.bailuntec.cost.api.domain.BuyDomain;
import com.blt.other.database.model.BuyPlanDetailDomain;
import com.blt.other.database.model.BuyPlanDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.purchasing.dto.BuyListDto;
import com.blt.other.module.purchasing.dto.BuyListPrintDto;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface BuyService {

    /**
     * 分页获取采购订单
     * @param pageSize
     * @param page
     * @return
     */
    Map<String,Object> getAllBuyList(int pageSize, int page);

    /**
     * 通过 buyno 获取采购单详情
     * @param buyno
     * @return
     */
    BuyListDto getBuyByBuyno(String buyno);

    /**
     * 修改采购单状态、信息
     * @param buyDomain
     * @return
     */
    Integer getUpdate(BuyDomain buyDomain);

    /**
     * 获取 BuyDomain
     * @param buyDomain
     * @return
     */
    BuyDomain getBuyDomain(BuyDomain buyDomain);

    List<BuyListDto> getDtoList(List<BuyDomain> list);

    Integer saveBuyFromPlanDetailList(List<BuyPlanDetailDomain> buy, BuyPlanDomain plan);

    BuyDomain getLastBuy();

    Integer updateNewBuyno(String oldBuyno, String newBuyno);

    /**
     * 采购单关联借支单审核
     * @param linkLendCost 关联的借支单
     * @param buyListDto 采购单
     * @return
     */
    String buyLinkLendCost(CostDomain linkLendCost, BuyListDto buyListDto, Integer updateUserId);

    /**
     * 采购单关联借支单判断
     * @param linkLendCost 关联的借支单
     * @param buyListDto 采购单
     * @return
     */
    String judgeLinkLendCost(CostDomain linkLendCost, BuyListDto buyListDto);

    /**
     * 获取要打印的采购单列表信息
     * @param printBuyIds
     * @return
     */
    List<BuyListPrintDto> getBuyPrintList(Integer[] printBuyIds);

    /**
     * 导出excel
     * @param buyIds
     * @return
     */
    String exportExcel(Integer[] buyIds);

    /**
     * 设置采购单分期信息
     * @param buyNo 分期主采购单号
     * @param payment 本期支付金额
     */
    void setInstallment(String buyNo, BigDecimal payment);

    /**
     * 更新分期支付主采购单分期信息
     * @param subBuyNo 分期子采购单号
     * @param payment
     */
    void updateInstallment(String subBuyNo, BigDecimal payment);

    /**
     * 废弃子采购单时删除子采购单信息及主采购单分期信息
     * @param subBuyNo
     */
    void deleteInstallment(String subBuyNo);

}
