package com.blt.other.module.cost.service.impl;

import com.blt.other.common.util.CurUtils;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostDetailDao;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostDetailService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class CostDetailServiceImpl implements CostDetailService {

    @Resource
    private CostDetailDao costDetailDao;
    @Resource
    CostDao costDao;

    @Override
    public List<CostDetailDomain> getCostDetailListByCostNo(String costNo) {
        return costDetailDao.selectListByCostNo(costNo);
    }

    @Override
    public CostDetailDomain getCostDetailByDetailNo(String detailNo) {
        return costDetailDao.selectByDetailNo(detailNo);
    }

    @Override
    public void deleteFilePath(String detailNo) {
        costDetailDao.deletedFilePath(detailNo);
    }


    @Transactional
    @Override
    public Integer update(CostDetailDomain domain) {


        List<CostDetailDomain> costDetailDomainList = costDetailDao.selectListByCostNo(domain.getCostNo());
        CostDomain costDomain = costDao.selectByCostNo(domain.getCostNo());



//        //费用单总金额重新计算
//        if (costDetailDomainList.stream().collect(Collectors.groupingBy(CostDetailDomain::getDic)).keySet().size() > 1) {
//            throw new RuntimeException("请统一货币单位");
//        }
//        BigDecimal totalAmount = costDetailDomainList.stream().map(CostDetailDomain::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
//        BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY");
//
//        costDomain.setToRmbRate(toRmbRate);
//        costDomain.setAmount(totalAmount);
//        costDomain.setAmountRmb(totalAmount.multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
//        costDomain.setDic(domain.getDic())


        //更新费用单
        return costDetailDao.update(domain);
    }
}
