package com.blt.other.module.cost.service.impl.costplan;

import com.bailuntec.common.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.database.model.CostPlanDomain;
import com.blt.other.database.model.CostPlanTempDomain;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.cost.model.CostDetailDomain;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostPlanService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * <p>
 * 借支单服务
 * </p>
 *
 * @author robbendev
 * @since 2020/10/16 1:25 下午
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class CostPlanNewLend1ServiceImpl extends AbstractCostPlanService implements CostPlanService {

    @Override
    public void save(CostPlanDomain planDomain) {
        this.doSaveFinanceRecord(planDomain);
        this.completedCostPlan(planDomain);
        //子项目和借支总金额
        planDomain.setPlanAmount(this.SaveCostPlanTemp(planDomain));
        planDomain.setCostPlanStatus(0);
        planDomain.setLendStatus(1);

        //init 借支单已还金额
        planDomain.setHadPay(BigDecimal.ZERO);
        //init 冲销金额
        planDomain.setCounteract(BigDecimal.ZERO);
        //init 借还单余额
        planDomain.setLendBalance(BigDecimal.ZERO);

        this.check(planDomain);
        costPlanDao.insert(planDomain);
    }

    @Override
    public void update(CostPlanDomain planDomain) {
        this.doSaveFinanceRecord(planDomain);
        this.completedCostPlan(planDomain);
        CostTypeDomain costTypeDomain = costTypeDao.selectByNo(planDomain.getTypeNo());

        planDomain.setTypeId(costTypeDomain.getId());
        //子项目和借支总金额
        planDomain.setPlanAmount(this.SaveCostPlanTemp(planDomain));
        costPlanDao.update(planDomain, new LambdaQueryWrapper<CostPlanDomain>()
                .eq(CostPlanDomain::getCostPlanNo, planDomain.getCostPlanNo()));
    }

    @Override
    public Integer affirm(String costPlanNo) {
        CostPlanDomain costPlanDomain = costPlanDao.selectByNo(costPlanNo);
        if (costPlanDomain.getCostPlanStatus() != 0) {
            throw new BizRuntimeException("只能更新待确认的计划单");
        }
        costPlanDomain.setCostPlanStatus(1);
        costPlanDao.update(costPlanDomain, new LambdaQueryWrapper<CostPlanDomain>()
                .eq(CostPlanDomain::getCostPlanNo, costPlanDomain.getCostPlanNo()));

        CostDomain costDomain = planToCost(costPlanDomain.getCostPlanNo());
        String costNo = getCostNo();
        costDomain.setCompensate(BigDecimal.ZERO);
        costDomain.setRepaymentAppliedAmount(BigDecimal.ZERO);

        costDomain.setCostNo(costNo);
        costDomain.setCostStatus(0);
        costDomain.setAmount(costPlanDomain.getPlanAmount());
        BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY");
        if (BigDecimal.ZERO.compareTo(toRmbRate) == 0 || (costDomain.getDic() != null && !costDomain.getDic().equals("CNY") && BigDecimal.ONE.compareTo(toRmbRate) == 0)) {
            throw new BizRuntimeException("获取汇率异常,请重试!");
        }
        costDomain.setToRmbRate(toRmbRate);
        costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        if(StringUtils.isBlank(costDomain.getCategoryName())){
            costDomain.setCategoryName(costDomain.getTypeName());
        }

        int insert = costDao.insert(costDomain);
        //增加借支明细
        List<CostPlanTempDomain> costPlanTempDomains = costPlanTempDao.selectListByPlanNo(costDomain.getCostPlanNo());
        if (costPlanTempDomains != null && costPlanTempDomains.size() > 0) {
            AtomicInteger index = new AtomicInteger(1);
            List<CostDetailDomain> listCostDetail = costPlanTempDomains.stream()
                    .map(costPlanTempDomain -> {
                        CostDetailDomain costDetailDomain = this.tempToDetail(costPlanTempDomain, costPlanDomain, index.getAndIncrement());
                        BeanUtils.copyProperties(costDomain, costDetailDomain);
                        costDetailDomain.setAmount(costPlanTempDomain.getAmount());
                        costDetailDomain.setProject(costPlanTempDomain.getProject());
                        return costDetailDomain;
                    }).collect(Collectors.toList());
           for (CostDetailDomain costDetail : listCostDetail) {
               if(StringUtils.isBlank(costDomain.getDic())){
                   costDetail.setDic("CNY");
               }
               if(StringUtils.isNotBlank(costDomain.getCategoryName())){
                   costDetail.setCategoryName(costDomain.getCategoryName());
               } else {
                   costDetail.setCategoryName(costDetail.getTypeName());
               }
               // 生成付款费用详情
               costDetailDao.insert(costDetail);
           }
        }
        costLogService.save(costDomain.getCostNo(), costDomain.getCreateUserid(), "由费用计划：" + costDomain.getCostPlanNo() + " 生成借支单");
        return insert;
    }

    private BigDecimal SaveCostPlanTemp(CostPlanDomain planDomain){
        //子项目和借支总金额
        BigDecimal amount = BigDecimal.ZERO;
        if (planDomain.getCostPlanTempDomainList() != null && planDomain.getCostPlanTempDomainList().size() > 0) {
            costPlanTempDao.deletedByPlanNoAndTempNo(planDomain.getCostPlanNo(),planDomain.getCostPlanNo());
            for (CostPlanTempDomain item: planDomain.getCostPlanTempDomainList()) {
                BigDecimal itemAmount = item.getAmount();
                String itemProject= item.getProject();
                BeanUtils.copyProperties(planDomain, item);
                CostPlanTempDomain costPlanTempDomain = new CostPlanTempDomain();
                costPlanTempDomain.setCostPlanNo(planDomain.getCostPlanNo());
                costPlanTempDomain.setTempNo(planDomain.getCostPlanNo());
                costPlanTempDomain.setAmount(itemAmount);
                costPlanTempDomain.setProject(itemProject);
                costPlanTempDomain.setAccountingSubjectNo("");
                //新增付款子项目
                costPlanTempDao.insert(costPlanTempDomain);
                amount = amount.add(item.getAmount());
            }
            planDomain.setPlanAmount(amount);
        }
        return  amount;
    }
}
