package com.blt.other.common.util;

import com.bailuntec.common.SpringContextUtil;
import com.blt.other.common.config.property.CostUrlProperties;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.cost.vo.CurVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

@Slf4j
public class CurUtils {

    /**
     * 获取汇率
     *
     * @param fromCur fromCur
     * @param toCur   toCur
     * @return exchange rate
     */
    public static BigDecimal getCur(String fromCur, String toCur) {

        log.info(fromCur);
        log.info(toCur);
        if (fromCur == null || fromCur.equalsIgnoreCase(toCur)) {
            return BigDecimal.ONE;
        } else {
            CostUrlProperties costUrlProperties = SpringContextUtil.getBean(CostUrlProperties.class);
            String getExchangeRateApi = costUrlProperties.getExchangeRateApi;

            RestTemplate restTemplate = new RestTemplate();
            String url = getExchangeRateApi + "?" + "fromCUr=" + fromCur + "&toCur=" + toCur;
            ResponseEntity<String> forEntity = restTemplate.getForEntity(url, String.class);
            if (200 == forEntity.getStatusCodeValue()) {
                String body = forEntity.getBody();
                assert body != null;
                body = body.toLowerCase();
                body = body.replace("\\", "");
                body = body.substring(1, body.length() - 1);
                CurVo curVo = (CurVo) MyMapperUtil.getObject(body, CurVo.class);
                return curVo.getRate();
            } else {
                return BigDecimal.ZERO;
            }
        }
    }

    public static String getCurDto(String dic) {
        if (null == dic || dic.isEmpty()) {
            return "";
        }
        Map<String, String> map = curMap();
        return map.get(dic);

    }

    private static Map<String, String> curMap() {
        Map<String, String> curMap = new HashMap<>();
        curMap.put("USD", "美元");
        curMap.put("EUR", "欧元");
        curMap.put("JPY", "日元");
        curMap.put("HKD", "港元");
        curMap.put("GBP", "英镑");
        curMap.put("AUD", "澳元");
        curMap.put("CNY", "人民币");
        curMap.put("CAD", "加拿大元");
        curMap.put("CZK", "捷克币");
        curMap.put("PLN", "波兰币");
        curMap.put("AED", "阿联酋币");
        curMap.put("INR", "卢比");
        return curMap;
    }

    /**
     * <p>
     * 数字转中文货币
     * </p>
     *
     * @param num 数字的金额
     * @return 中文的金额
     */
    public static String digitUppercase(String num) {
        String fraction[] = {"角", "分"};
        String[] digit = {"零", "壹", "贰", "叁", "肆", "伍", "陆", "柒", "捌", "玖"};
        String[] unit1 = {"", "拾", "佰", "仟"};//把钱数分成段,每四个一段,实际上得到的是一个二维数组
        String[] unit2 = {"元", "万", "亿", "万亿"}; //把钱数分成段,每四个一段,实际上得到的是一个二维数组
        BigDecimal bigDecimal = new BigDecimal(num);
        bigDecimal = bigDecimal.multiply(new BigDecimal(100));

        String strVal = String.valueOf(bigDecimal.toBigInteger());
        String head = strVal.substring(0, strVal.length() - 2);         //整数部分
        String end = strVal.substring(strVal.length() - 2);              //小数部分
        String endMoney = "";
        StringBuilder headMoney = new StringBuilder();
        if ("00".equals(end)) {
            endMoney = "整";
        } else {
            if (!end.substring(0, 1).equals("0")) {
                endMoney += digit[Integer.parseInt(end.substring(0, 1))] + "角";
            } else if (end.substring(0, 1).equals("0") && !end.substring(1, 2).equals("0")) {
                endMoney += "零";
            }
            if (!end.substring(1, 2).equals("0")) {
                endMoney += digit[Integer.parseInt(end.substring(1, 2))] + "分";
            }
        }
        char[] chars = head.toCharArray();
        Map<String, Boolean> map = new HashMap<>();//段位置是否已出现zero
        boolean zeroKeepFlag = false;//0连续出现标志
        int vidxtemp = 0;
        for (int i = 0; i < chars.length; i++) {
            int idx = (chars.length - 1 - i) % 4;//段内位置  unit1
            int vidx = (chars.length - 1 - i) / 4;//段位置 unit2
            String s = digit[Integer.parseInt(String.valueOf(chars[i]))];
            if (!"零".equals(s)) {
                headMoney.append(s).append(unit1[idx]).append(unit2[vidx]);
                zeroKeepFlag = false;
            } else if (i == chars.length - 1 || map.get("zero" + vidx) != null) {
                headMoney.append("");
            } else {
                headMoney.append(s);
                zeroKeepFlag = true;
                map.put("zero" + vidx, true);//该段位已经出现0；
            }
            if (vidxtemp != vidx || i == chars.length - 1) {
                headMoney = new StringBuilder(headMoney.toString().replaceAll(unit2[vidx], ""));
                headMoney.append(unit2[vidx]);
            }
            if (zeroKeepFlag && (chars.length - 1 - i) % 4 == 0) {
                headMoney = new StringBuilder(headMoney.toString().replaceAll("零", ""));
            }
        }
        return headMoney + endMoney;
    }
}
