package com.blt.other.module.cost.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.blt.other.database.model.CostTypeDomain;
import com.blt.other.module.cost.dto.request.CostTypeBaseReq;
import com.blt.other.module.cost.dto.response.CostTypeResult;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface CostTypeDao extends BaseMapper<CostTypeDomain> {

    /**
     * 分页获取费用类型
     *
     * @param page page
     * @param req  req
     * @return res
     */
    IPage<CostTypeResult> queryPage(@Param("page") IPage<CostTypeResult> page,
                                    @Param("req") CostTypeBaseReq req);

    /**
     * 获取全部费用类型
     *
     * @param req req
     * @return res
     */
    List<CostTypeResult> queryAll(@Param("req") CostTypeBaseReq req);

    /**
     * 根据编号查
     *
     * @param typeNo typeNo
     * @return res
     */
    CostTypeDomain selectByNo(String typeNo);

    /**
     * 获取费用类型详情
     *
     * @param id id
     * @return res
     */
    CostTypeResult queryDetail(Integer id);

    /**
     * 获取费用类型详情
     *
     * @param typeNo typeNo
     * @return res
     */
    CostTypeResult queryByNo(String typeNo);

    /**
     * 根据费用类型名称和类型查询
     *
     * @param name name
     * @param type type
     * @return res
     */
    CostTypeDomain selectByNameAndType(@Param("name") String name, @Param("type") Integer type);

    /**
     * @return res
     */
    List<CostTypeDomain> selectTestType();

    /**
     * 根据类型名称和会计科目名称查询
     *
     * @param typeName
     * @param accountSubjectName
     * @return
     */
    CostTypeDomain selectByTypeNameAndAccountSubjectName(@Param("typeName") String typeName, @Param("accountSubjectName") String accountSubjectName);
}
