package com.blt.other.other_purchasing.service.impl;

import com.blt.other.other_database.model.BuyDetailDomain;
import com.blt.other.other_purchasing.dao.BuyDetailDao;
import com.blt.other.other_purchasing.service.BuyDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class BuyDetailServiceImpl implements BuyDetailService {

    @Autowired
    private BuyDetailDao buyDetailDao;

    /**
     * 根据采购单号获取采购单子项目
     * @param buyno
     * @return
     */
    @Override
    public List<BuyDetailDomain> getDetailListByBuyno(String buyno) {
        List<BuyDetailDomain> buyDetailDomains = buyDetailDao.selectByBuyno(buyno);
        return buyDetailDomains;
    }

    @Override
    public Integer updateNewBuyno(String oldBuyno, String newBuyno) {
        return buyDetailDao.updateNewBuyno(oldBuyno,newBuyno);
    }
}
