package com.blt.other.other_purchasing.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_purchasing.dto.BuyPlanDto;
import com.blt.other.other_purchasing.service.BuyPlanSearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/purchasing/plan/search")
public class PurchasingPlanSearchController {

    @Autowired
    private BuyPlanSearchService buyPlanSearchService;

    /**
     * 采购计划模糊查询
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/key")
    public Map<String,Object> key(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String key = request.getParameter("key");
        List<BuyPlanDto> buyPlanDtos = buyPlanSearchService.searchByKey(key);
        Map<String,Object> map = new HashMap<>();
        map.put("plans",buyPlanDtos);
        map.put("success",true);
        map.put("msg","");
        return map;
    }
}
