package com.bailuntec.cost.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Data
public class CostInputDto {
    // 费用单编号
    @ApiModelProperty(value = "主体编号",required = true)
    private String companyNo;

    @ApiModelProperty(value = "费用类型ID",required = true)
    private Integer typeId;


    @ApiModelProperty(value = "创建人id",required = true)
    private Integer createUserid;
    @ApiModelProperty("费用单备注")
    private String costRemark;

    @ApiModelProperty(value = "文件地址",required = true)
    private String filePath;

    @ApiModelProperty(value = "费用总金额",required = true)
    private BigDecimal amount;

    @ApiModelProperty(value = "费用币种",required = true)
    private String dic;

    @ApiModelProperty(value = "收款银行（平台）",required = true)
    private String bankName;
    @ApiModelProperty(value = "收款账户",required = true)
    private String bankCard;
    @ApiModelProperty(value = "收款用户名",required = true)
    private String bankCardUser;
    @ApiModelProperty(value = "收款/付款单位",required = true)
    private String bankCompany;


    @ApiModelProperty(value = "1 付款费用 2 收款费用",required = true)
    private Integer costForm;

    @ApiModelProperty("付款理由")
    private String costReason;

    @ApiModelProperty("项目")
    private String projectType;

    @ApiModelProperty("客户编号")
    private String customerNum;

    @ApiModelProperty(value = "费用来源 1-默认 2-WMS 3-调拨系统 4-工资系统 5-4k",required = true)
    private String sourceFrom;

    @ApiModelProperty(value = "作废，true/false")
    private Boolean invalid;

}
