package com.blt.other.module.sys.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.bailuntec.common.ListUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.common.util.SessionUtils;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaDepartment;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.sys.dao.DepartmentReviewerMapper;
import com.blt.other.module.sys.dto.request.*;
import com.blt.other.module.sys.dto.response.DepartmentReviewerListItem;
import com.blt.other.module.sys.model.CostReviewer;
import com.blt.other.module.sys.model.DepartmentReviewer;
import com.blt.other.module.sys.service.ICostReviewerService;
import com.blt.other.module.sys.service.IDepartmentReviewerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 部门审核人 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-12-21
 */
@Slf4j
@Service
public class DepartmentReviewerServiceImpl extends ServiceImpl<DepartmentReviewerMapper, DepartmentReviewer> implements IDepartmentReviewerService {

    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    ICostReviewerService costReviewerService;
    @Resource
    OaUserMapper oaUserMapper;
    @Resource
    OaDepartmentMapper oaDepartmentMapper;

    @Override
    public IPage<DepartmentReviewerListItem> departmentReviewerList(DepartmentReviewerListReq req) {
        IPage<DepartmentReviewerListItem> page = new Page<>(req.getPageNum(), req.getPageSize());
        page = baseMapper.departmentReviewerList(page, req);

        if (ListUtil.isNotEmpty(page.getRecords())) {
            Map<Integer, List<CostReviewer>> cMap = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.departmentReviewer)
                    .in(CostReviewer::getReferId, page.getRecords().stream().map(DepartmentReviewerListItem::getId).collect(Collectors.toList())))
                    .stream()
                    .collect(Collectors.groupingBy(CostReviewer::getReferId));
            page.getRecords().forEach(departmentReviewerListItem -> departmentReviewerListItem.setCostReviewerList(cMap.get(departmentReviewerListItem.getId())));

            Map<Integer, OaDepartment> dMap = oaDepartmentMapper.selectByIds(page.getRecords().stream().map(DepartmentReviewerListItem::getPrimaryDepartmentId).collect(Collectors.toList()))
                    .stream()
                    .collect(Collectors.toMap(OaDepartment::getDepartmentId, oaDepartment -> oaDepartment));

            page.getRecords().forEach(departmentReviewerListItem -> departmentReviewerListItem.setCompanyName(dMap.get(departmentReviewerListItem.getPrimaryDepartmentId()).getCompanyName()));

        }
        return page;
    }

    @Override
    public void modifyDepartmentReviewer(ModifyDepartmentReviewerReq req) {
        log.info("更新部门审核人配置");

        DepartmentReviewer departmentReviewer = this.getById(req.getId());
        departmentReviewer.setAutoReviewAmount(req.getAutoReviewerAmount());
        if (SessionUtils.getSysUser() != null) {
            departmentReviewer.setUpdateUserId(SessionUtils.getCurrentUserId());
            departmentReviewer.setUpdateUserName(SessionUtils.getSysUser().getUserName());
        }

        if (ListUtil.isNotEmpty(req.getDepartmentReviewerUserIdList())) {
            costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.departmentReviewer)
                    .eq(CostReviewer::getReferId, req.getId()));

            this.saveDepartmentCostReviewer(req.getDepartmentReviewerUserIdList(), req.getId());
        }

    }

    @Override
    public void addDepartmentReviewer(AddDepartmentReviewerReq req) {
        log.info("新增部门审核人配置");

        DepartmentReviewer departmentReviewer = new DepartmentReviewer();

        departmentReviewer.setAutoReviewAmount(req.getAutoReviewAmount());

        OaDepartment primaryDepartment = oaDepartmentMapper.selectByDepartmentId(req.getPrimaryDepartmentId());
        departmentReviewer.setPrimaryDepartmentId(primaryDepartment.getDepartmentId());
        departmentReviewer.setPrimaryDepartmentName(primaryDepartment.getName());

        if (req.getSecondDepartmentId() != null && req.getSecondDepartmentId() != 0) {
            OaDepartment secondDepartment = oaDepartmentMapper.selectByDepartmentId(req.getSecondDepartmentId());
            departmentReviewer.setSecondDepartmentId(secondDepartment.getDepartmentId());
            departmentReviewer.setSecondDepartmentName(secondDepartment.getName());
        }

        departmentReviewer.setUpdateUserId(SessionUtils.getCurrentUserId());
        departmentReviewer.setUpdateUserName(SessionUtils.getSysUser().getUserName());

        baseMapper.insert(departmentReviewer);


        this.saveDepartmentCostReviewer(req.getDepartmentReviewerUserIdList(), departmentReviewer.getId());

    }

    private void saveDepartmentCostReviewer(List<Integer> departmentReviewerUserIdList, Integer departmentReviewerId) {

        costReviewerService.saveBatch(departmentReviewerUserIdList.stream()
                .map(id -> {
                    CostReviewer costReviewer = new CostReviewer();
                    costReviewer.setReferId(departmentReviewerId);
                    costReviewer.setReviewerUserId(id);
                    costReviewer.setReviewerUserName(oaUserMapper.selectByOaUserId(id).getUserName());
                    costReviewer.setType(CostReviewer.departmentReviewer);
                    return costReviewer;
                })
                .collect(Collectors.toList()));
    }

    @Override
    public void removeDepartmentReviewer(RemoveDepartmentReviewerReq req) {
        log.info("删除部门审核人");
        baseMapper.deleteById(req.getId());
    }

    @Override
    public void importExcel(DepartmentReviewerImportReq excel) {

    }

    @Override
    public void exportExcel(HttpServletResponse response, DepartmentReviewerExportReq req) throws IOException {

        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
//
        String fileName = URLEncoder.encode("模版", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        LongestMatchColumnWidthStyleStrategy longestMatchColumnWidthStyleStrategy = new LongestMatchColumnWidthStyleStrategy();

        req.setPageNum(1);
        req.setPageSize(1000);
        List<DepartmentReviewerListItem> list = this.departmentReviewerList(req).getRecords();
        list.forEach(item -> item.setCostReviewerNames(item.getCostReviewerList().stream().map(CostReviewer::getReviewerUserName).collect(Collectors.joining(","))));
        EasyExcel.write(response.getOutputStream(), DepartmentReviewerListItem.class).sheet("sheet").doWrite(list);
    }
}
