package com.blt.other.module.entrepot.dao;

import com.blt.other.database.model.StorageDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface StorageDao {

    /**
     * 新增入库单记录
     * @param storageDomain
     * @return
     */
    Integer insert(StorageDomain storageDomain);

    /**
     * 获取所有入库单
     * @return
     */
    List<StorageDomain> selectAll();

    /**
     * 根据 storageno 获取入库表
     *
     */
    StorageDomain select(String storageno);

    /**
     * update 入库单
     * @param storageDomain
     * @return
     */
    Integer update(StorageDomain storageDomain);

    /**
     * 根据 buyNo 获取入库表
     *
     */
    StorageDomain selectByBuyNo(String buyNo);

    /**
     * 根据关键字获取入库信息
     * @param key
     * @return
     */
    List<StorageDomain> selectByKey(@Param("key") String key);
}
